/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.nodemodels;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredict;
import org.neo4j.gds.ml.nodemodels.NodeClassificationPredictAlgorithmFactory;
import org.neo4j.gds.ml.nodemodels.NodeClassificationStreamConfig;
import org.neo4j.gds.ml.nodemodels.NodeClassificationTrainConfig;
import org.neo4j.gds.ml.nodemodels.multiclasslogisticregression.MultiClassNLRData;
import org.neo4j.gds.ml.nodemodels.multiclasslogisticregression.MultiClassNLRResult;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.StreamProc;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.GraphStoreValidation;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.loading.GraphStoreWithConfig;
import org.neo4j.graphalgo.core.model.ModelCatalog;
import org.neo4j.graphalgo.core.utils.paged.HugeLongArray;
import org.neo4j.graphalgo.core.utils.paged.HugeObjectArray;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPredictStreamProc
extends StreamProc<NodeClassificationPredict, MultiClassNLRResult, StreamResult, NodeClassificationStreamConfig> {
    @Procedure(name="gds.alpha.ml.nodeClassification.predict.stream", mode=Mode.READ)
    @Description(value="Predicts classes for all nodes based on a previously trained model")
    public Stream<StreamResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult result = this.compute(graphNameOrConfig, configuration);
        return this.stream((AlgoBaseProc.ComputationResult<NodeClassificationPredict, MultiClassNLRResult, NodeClassificationStreamConfig>)result);
    }

    protected Stream<StreamResult> stream(AlgoBaseProc.ComputationResult<NodeClassificationPredict, MultiClassNLRResult, NodeClassificationStreamConfig> computationResult) {
        return (Stream)this.runWithExceptionLogging("Graph streaming failed", () -> {
            Graph graph = computationResult.graph();
            MultiClassNLRResult result = (MultiClassNLRResult)computationResult.result();
            HugeLongArray predictedClasses = result.predictedClasses();
            Optional predictedProbabilities = result.predictedProbabilities();
            return LongStream.range(0L, graph.nodeCount()).boxed().map(nodeId -> new StreamResult((long)nodeId, predictedClasses.get(nodeId.longValue()), this.nodePropertiesAsList(predictedProbabilities, (long)nodeId)));
        });
    }

    private List<Double> nodePropertiesAsList(Optional<HugeObjectArray<double[]>> predictedProbabilities, long nodeId) {
        return predictedProbabilities.map(p -> {
            double[] values = (double[])p.get(nodeId);
            return Arrays.stream(values).boxed().collect(Collectors.toList());
        }).orElse(null);
    }

    protected void validateConfigsAndGraphStore(GraphStoreWithConfig graphStoreWithConfig, NodeClassificationStreamConfig config) {
        NodeClassificationTrainConfig trainConfig = (NodeClassificationTrainConfig)ModelCatalog.get((String)config.username(), (String)config.modelName(), MultiClassNLRData.class, NodeClassificationTrainConfig.class).trainConfig();
        GraphStoreValidation.validate((GraphStoreWithConfig)graphStoreWithConfig, (AlgoBaseConfig)trainConfig);
    }

    protected NodeClassificationStreamConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return NodeClassificationStreamConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<NodeClassificationPredict, NodeClassificationStreamConfig> algorithmFactory() {
        return new NodeClassificationPredictAlgorithmFactory();
    }

    protected NodeProperties nodeProperties(AlgoBaseProc.ComputationResult<NodeClassificationPredict, MultiClassNLRResult, NodeClassificationStreamConfig> computationResult) {
        return super.nodeProperties(computationResult);
    }

    protected StreamResult streamResult(long originalNodeId, long internalNodeId, NodeProperties nodeProperties) {
        throw new UnsupportedOperationException("NodeClassification handles result building individually.");
    }

    public static final class StreamResult {
        public long nodeId;
        public long predictedClass;
        public List<Double> predictedProbabilities;

        StreamResult(long nodeId, long predictedClass) {
            this(nodeId, predictedClass, null);
        }

        StreamResult(long nodeId, long predictedClass, List<Double> predictedProbabilities) {
            this.nodeId = nodeId;
            this.predictedClass = predictedClass;
            this.predictedProbabilities = predictedProbabilities;
        }
    }
}

