/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongIntScatterMap;
import com.carrotsearch.hppc.cursors.LongIntCursor;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import org.immutables.value.Value;
import org.neo4j.gds.pregel.SpeakerListenerLPAConfigImpl;
import org.neo4j.graphalgo.annotation.Configuration;
import org.neo4j.graphalgo.annotation.ValueClass;
import org.neo4j.graphalgo.api.nodeproperties.ValueType;
import org.neo4j.graphalgo.beta.pregel.Messages;
import org.neo4j.graphalgo.beta.pregel.PregelComputation;
import org.neo4j.graphalgo.beta.pregel.PregelConfig;
import org.neo4j.graphalgo.beta.pregel.PregelSchema;
import org.neo4j.graphalgo.beta.pregel.annotation.PregelProcedure;
import org.neo4j.graphalgo.beta.pregel.context.ComputeContext;
import org.neo4j.graphalgo.beta.pregel.context.InitContext;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;

@PregelProcedure(name="gds.alpha.sllpa", description="The Speaker Listener Label Propagation algorithm is a fast algorithm for finding overlapping communities in a graph.")
public class SpeakerListenerLPA
implements PregelComputation<SpeakerListenerLPAConfig> {
    public static final String LABELS_PROPERTY = "communityIds";
    private final ThreadLocal<Random> random = ThreadLocal.withInitial(() -> new Random(seed));

    public SpeakerListenerLPA() {
        this(System.currentTimeMillis());
    }

    public SpeakerListenerLPA(long seed) {
    }

    public PregelSchema schema(SpeakerListenerLPAConfig config) {
        return new PregelSchema.Builder().add(LABELS_PROPERTY, ValueType.LONG_ARRAY).build();
    }

    public void init(InitContext<SpeakerListenerLPAConfig> context) {
        long[] initialLabels = new long[((SpeakerListenerLPAConfig)context.config()).maxIterations()];
        Arrays.fill(initialLabels, context.nodeId());
        context.setNodeValue(LABELS_PROPERTY, initialLabels);
    }

    public void compute(ComputeContext<SpeakerListenerLPAConfig> context, Messages messages) {
        long[] labels = context.longArrayNodeValue(LABELS_PROPERTY);
        if (context.isInitialSuperstep()) {
            labels[0] = context.nodeId();
            context.sendToNeighbors((double)context.nodeId());
        } else if (context.superstep() < ((SpeakerListenerLPAConfig)context.config()).propagationSteps()) {
            this.listen(context, messages, labels);
            this.speak(context, labels);
        } else {
            this.listen(context, messages, labels);
            this.prune(context, labels);
        }
    }

    private void listen(ComputeContext<SpeakerListenerLPAConfig> context, Messages messages, long[] labels) {
        if (!messages.isEmpty()) {
            LongIntScatterMap labelVotes = new LongIntScatterMap();
            long winningLabel = 0L;
            int maxFrequency = Integer.MIN_VALUE;
            for (Double message : messages) {
                long currentLabel = message.longValue();
                int updatedFrequency = labelVotes.addTo(currentLabel, 1);
                if (updatedFrequency > maxFrequency) {
                    winningLabel = currentLabel;
                    maxFrequency = updatedFrequency;
                    continue;
                }
                if (updatedFrequency != maxFrequency || currentLabel >= winningLabel) continue;
                winningLabel = currentLabel;
            }
            labels[context.superstep()] = winningLabel;
        }
    }

    private void speak(ComputeContext<SpeakerListenerLPAConfig> context, long[] labels) {
        context.getNeighbours().forEach(neighbor -> {
            int randomLabelPosition = this.random.get().nextInt(context.superstep() + 1);
            long labelToSend = labels[randomLabelPosition];
            context.sendTo(neighbor, (double)labelToSend);
        });
    }

    private void prune(ComputeContext<SpeakerListenerLPAConfig> context, long[] labels) {
        LongIntScatterMap labelVotes = new LongIntScatterMap();
        for (long label : labels) {
            labelVotes.addTo(label, 1);
        }
        LongArrayList labelsToKeep = new LongArrayList(labels.length);
        for (LongIntCursor labelVote : labelVotes) {
            double relativeFrequency = (double)labelVote.value / (double)labels.length;
            if (!(relativeFrequency > ((SpeakerListenerLPAConfig)context.config()).minAssociationStrength())) continue;
            labelsToKeep.add(labelVote.key);
        }
        context.setNodeValue(LABELS_PROPERTY, labelsToKeep.size() == labels.length ? labelsToKeep.buffer : labelsToKeep.toArray());
    }

    @ValueClass
    @Configuration
    public static interface SpeakerListenerLPAConfig
    extends PregelConfig {
        @Value.Default
        default public double minAssociationStrength() {
            return 0.2;
        }

        public static SpeakerListenerLPAConfig of(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitConfig, CypherMapWrapper userConfig) {
            return new SpeakerListenerLPAConfigImpl(graphName, maybeImplicitConfig, username, userConfig);
        }

        @Value.Derived
        @Configuration.Ignore
        default public boolean isAsynchronous() {
            return true;
        }

        @Value.Derived
        @Configuration.Ignore
        default public int propagationSteps() {
            return this.maxIterations() - 1;
        }
    }
}

