/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.ml.MLTrainResult;
import org.neo4j.gds.ml.linkmodels.LinkPredictionTrain;
import org.neo4j.gds.ml.linkmodels.LinkPredictionTrainConfig;
import org.neo4j.gds.ml.linkmodels.logisticregression.LinkLogisticRegressionData;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.TrainProc;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.GraphStore;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.GraphCreateConfigValidations;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.model.Model;
import org.neo4j.graphalgo.core.model.ModelCatalog;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.progress.ProgressEventTracker;
import org.neo4j.graphalgo.exceptions.MemoryEstimationNotImplementedException;
import org.neo4j.graphalgo.utils.StringFormatting;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LinkPredictionTrainProc
extends TrainProc<LinkPredictionTrain, LinkLogisticRegressionData, LinkPredictionTrainConfig> {
    @Procedure(name="gds.alpha.ml.linkPrediction.train", mode=Mode.READ)
    @Description(value="Trains a link prediction model")
    public Stream<MLTrainResult> train(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult result = this.compute(graphNameOrConfig, configuration);
        ModelCatalog.set((Model)((Model)result.result()));
        return Stream.of(new MLTrainResult((Model)result.result(), result.computeMillis()));
    }

    protected LinkPredictionTrainConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return LinkPredictionTrainConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected void validateConfigs(GraphCreateConfig graphCreateConfig, LinkPredictionTrainConfig config) {
        GraphCreateConfigValidations.validateIsUndirectedGraph((GraphCreateConfig)graphCreateConfig, (AlgoBaseConfig)config);
        if (config.params().isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No model candidates (params) specified, we require at least one", (Object[])new Object[0]));
        }
    }

    protected AlgorithmFactory<LinkPredictionTrain, LinkPredictionTrainConfig> algorithmFactory() {
        return new AlgorithmFactory<LinkPredictionTrain, LinkPredictionTrainConfig>(){

            public AlgorithmFactory.GraphAndAlgorithm<LinkPredictionTrain> build(GraphStore graphStore, LinkPredictionTrainConfig configuration, AllocationTracker tracker, Log log, ProgressEventTracker eventTracker) {
                Graph trainGraph = graphStore.getGraph(configuration.nodeLabelIdentifiers(graphStore), List.of(configuration.trainRelationshipType()), Optional.of("label"));
                Graph testGraph = graphStore.getGraph(configuration.nodeLabelIdentifiers(graphStore), List.of(configuration.testRelationshipType()), Optional.of("label"));
                LinkPredictionTrain algo = new LinkPredictionTrain(trainGraph, testGraph, configuration, log);
                return AlgorithmFactory.GraphAndAlgorithm.of((Graph)trainGraph, (Algorithm)algo);
            }

            public LinkPredictionTrain build(Graph graph, LinkPredictionTrainConfig configuration, AllocationTracker tracker, Log log, ProgressEventTracker eventTracker) {
                throw new UnsupportedOperationException("Link Prediction requires two graphs as input.");
            }

            public MemoryEstimation memoryEstimation(LinkPredictionTrainConfig configuration) {
                throw new MemoryEstimationNotImplementedException();
            }
        };
    }
}

