/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredict;
import org.neo4j.gds.ml.linkmodels.LinkPredictionPredictMutateConfig;
import org.neo4j.gds.ml.linkmodels.LinkPredictionResult;
import org.neo4j.gds.ml.linkmodels.LinkPredictionTrainConfig;
import org.neo4j.gds.ml.linkmodels.logisticregression.LinkLogisticRegressionData;
import org.neo4j.gds.ml.linkmodels.logisticregression.LinkLogisticRegressionPredictor;
import org.neo4j.graphalgo.AbstractAlgorithmFactory;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.MutateProc;
import org.neo4j.graphalgo.Orientation;
import org.neo4j.graphalgo.RelationshipType;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.Relationships;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.GraphCreateConfigValidations;
import org.neo4j.graphalgo.core.Aggregation;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.loading.construction.GraphFactory;
import org.neo4j.graphalgo.core.loading.construction.RelationshipsBuilder;
import org.neo4j.graphalgo.core.model.Model;
import org.neo4j.graphalgo.core.model.ModelCatalog;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.exceptions.MemoryEstimationNotImplementedException;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.StandardMutateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.values.storable.NumberType;

public class LinkPredictionPredictMutateProc
extends MutateProc<LinkPredictionPredict, LinkPredictionResult, MutateResult, LinkPredictionPredictMutateConfig> {
    @Procedure(name="gds.alpha.ml.linkPrediction.predict.mutate", mode=Mode.READ)
    @Description(value="Predicts relationships for all node pairs based on a previously trained link prediction model")
    public Stream<MutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult result = this.compute(graphNameOrConfig, configuration);
        return this.mutate(result);
    }

    protected void validateConfigs(GraphCreateConfig graphCreateConfig, LinkPredictionPredictMutateConfig config) {
        GraphCreateConfigValidations.validateIsUndirectedGraph((GraphCreateConfig)graphCreateConfig, (AlgoBaseConfig)config);
    }

    protected LinkPredictionPredictMutateConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return LinkPredictionPredictMutateConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<LinkPredictionPredict, LinkPredictionPredictMutateConfig> algorithmFactory() {
        return new AbstractAlgorithmFactory<LinkPredictionPredict, LinkPredictionPredictMutateConfig>(){

            protected long taskVolume(Graph graph, LinkPredictionPredictMutateConfig configuration) {
                return graph.nodeCount() * graph.nodeCount();
            }

            protected String taskName() {
                return "LinkPredictionPredict";
            }

            protected LinkPredictionPredict build(Graph graph, LinkPredictionPredictMutateConfig configuration, AllocationTracker tracker, ProgressLogger progressLogger) {
                Model model = ModelCatalog.get((String)configuration.username(), (String)configuration.modelName(), LinkLogisticRegressionData.class, LinkPredictionTrainConfig.class);
                return new LinkPredictionPredict(new LinkLogisticRegressionPredictor((LinkLogisticRegressionData)model.data()), graph, configuration.batchSize(), configuration.concurrency(), configuration.topN(), tracker, progressLogger, configuration.threshold());
            }

            public MemoryEstimation memoryEstimation(LinkPredictionPredictMutateConfig configuration) {
                throw new MemoryEstimationNotImplementedException();
            }
        };
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(AlgoBaseProc.ComputationResult<LinkPredictionPredict, LinkPredictionResult, LinkPredictionPredictMutateConfig> computeResult) {
        return new MutateResult.Builder();
    }

    protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, AlgoBaseProc.ComputationResult<LinkPredictionPredict, LinkPredictionResult, LinkPredictionPredictMutateConfig> computationResult) {
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().aggregation(Aggregation.SINGLE).nodes((IdMapping)computationResult.graph().nodeMapping()).orientation(Orientation.UNDIRECTED).loadRelationshipProperty(true).concurrency(1).executorService(Pools.DEFAULT).tracker(AllocationTracker.empty()).build();
        ((LinkPredictionResult)computationResult.result()).stream().forEach(predictedLink -> relationshipsBuilder.addFromInternal(predictedLink.sourceId(), predictedLink.targetId(), predictedLink.probability()));
        Relationships relationships = relationshipsBuilder.build();
        LinkPredictionPredictMutateConfig config = (LinkPredictionPredictMutateConfig)computationResult.config();
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withMutateMillis(arg_0));){
            computationResult.graphStore().addRelationshipType(RelationshipType.of((String)config.mutateRelationshipType()), Optional.of(config.mutateProperty()), Optional.of(NumberType.FLOATING_POINT), relationships);
        }
        resultBuilder.withRelationshipsWritten(relationships.topology().elementCount());
    }

    public static final class MutateResult
    extends StandardMutateResult {
        public final long relationshipsWritten;

        MutateResult(long createMillis, long computeMillis, long mutateMillis, long relationshipsWritten, Map<String, Object> configuration) {
            super(createMillis, computeMillis, 0L, mutateMillis, configuration);
            this.relationshipsWritten = relationshipsWritten;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.createMillis, this.computeMillis, this.mutateMillis, this.relationshipsWritten, this.config.toMap());
            }
        }
    }
}

