/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.triangle;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.GraphCreateConfigValidations;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.impl.triangle.TriangleStream;
import org.neo4j.graphalgo.triangle.TriangleCountBaseConfig;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class TriangleProc
extends AlgoBaseProc<TriangleStream, Stream<TriangleStream.Result>, TriangleCountBaseConfig> {
    private static final String DESCRIPTION = "Triangles streams the nodeIds of each triangle in the graph.";

    protected void validateConfigs(GraphCreateConfig graphCreateConfig, TriangleCountBaseConfig config) {
        GraphCreateConfigValidations.validateIsUndirectedGraph((GraphCreateConfig)graphCreateConfig, (AlgoBaseConfig)config);
    }

    @Procedure(name="gds.alpha.triangles", mode=Mode.READ)
    @Description(value="Triangles streams the nodeIds of each triangle in the graph.")
    public Stream<TriangleStream.Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration, false, false);
        Graph graph = computationResult.graph();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.empty();
        }
        return (Stream)computationResult.result();
    }

    protected TriangleCountBaseConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return TriangleCountBaseConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<TriangleStream, TriangleCountBaseConfig> algorithmFactory() {
        return (graph, configuration, tracker, log, eventTracker) -> (TriangleStream)new TriangleStream(graph, Pools.DEFAULT, configuration.concurrency()).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)this.transaction));
    }
}

