/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.similarity;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.impl.similarity.CosineAlgorithm;
import org.neo4j.graphalgo.impl.similarity.CosineConfig;
import org.neo4j.graphalgo.impl.similarity.CosineConfigImpl;
import org.neo4j.graphalgo.results.SimilarityResult;
import org.neo4j.graphalgo.results.SimilarityStatsResult;
import org.neo4j.graphalgo.results.SimilaritySummaryResult;
import org.neo4j.graphalgo.similarity.AlphaSimilarityProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class CosineProc
extends AlphaSimilarityProc<CosineAlgorithm, CosineConfig> {
    private static final String DESCRIPTION = "Cosine-similarity is an algorithm for finding similar nodes based on the cosine similarity metric.";

    @Procedure(name="gds.alpha.similarity.cosine.stream", mode=Mode.READ)
    @Description(value="Cosine-similarity is an algorithm for finding similar nodes based on the cosine similarity metric.")
    public Stream<SimilarityResult> cosineStream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.cosine.write", mode=Mode.WRITE)
    @Description(value="Cosine-similarity is an algorithm for finding similar nodes based on the cosine similarity metric.")
    public Stream<SimilaritySummaryResult> cosineWrite(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.cosine.stats", mode=Mode.READ)
    @Description(value="Cosine-similarity is an algorithm for finding similar nodes based on the cosine similarity metric.")
    public Stream<SimilarityStatsResult> cosineStats(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats(graphNameOrConfig, configuration);
    }

    protected CosineConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper userInput) {
        return new CosineConfigImpl(graphName, maybeImplicitCreate, username, userInput);
    }

    @Override
    CosineAlgorithm newAlgo(CosineConfig config, AllocationTracker tracker) {
        return new CosineAlgorithm(config, this.api);
    }
}

