/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.similarity;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.HdrHistogram.DoubleHistogram;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.SecureTransaction;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.impl.similarity.ApproxNearestNeighborsAlgorithm;
import org.neo4j.graphalgo.impl.similarity.ApproximateNearestNeighborsConfig;
import org.neo4j.graphalgo.impl.similarity.ApproximateNearestNeighborsConfigImpl;
import org.neo4j.graphalgo.impl.similarity.Computations;
import org.neo4j.graphalgo.impl.similarity.CosineAlgorithm;
import org.neo4j.graphalgo.impl.similarity.CosineConfig;
import org.neo4j.graphalgo.impl.similarity.EuclideanAlgorithm;
import org.neo4j.graphalgo.impl.similarity.EuclideanConfig;
import org.neo4j.graphalgo.impl.similarity.ImmutableCosineConfig;
import org.neo4j.graphalgo.impl.similarity.ImmutableEuclideanConfig;
import org.neo4j.graphalgo.impl.similarity.ImmutableJaccardConfig;
import org.neo4j.graphalgo.impl.similarity.ImmutablePearsonConfig;
import org.neo4j.graphalgo.impl.similarity.JaccardAlgorithm;
import org.neo4j.graphalgo.impl.similarity.JaccardConfig;
import org.neo4j.graphalgo.impl.similarity.PearsonAlgorithm;
import org.neo4j.graphalgo.impl.similarity.PearsonConfig;
import org.neo4j.graphalgo.impl.similarity.SimilarityAlgorithm;
import org.neo4j.graphalgo.impl.similarity.SimilarityAlgorithmResult;
import org.neo4j.graphalgo.impl.similarity.SimilarityConfig;
import org.neo4j.graphalgo.impl.similarity.SimilarityInput;
import org.neo4j.graphalgo.results.ApproxSimilaritySummaryResult;
import org.neo4j.graphalgo.results.SimilarityExporter;
import org.neo4j.graphalgo.results.SimilarityResult;
import org.neo4j.graphalgo.similarity.AlphaSimilarityProc;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ApproxNearestNeighborsProc
extends AlphaSimilarityProc<ApproxNearestNeighborsAlgorithm<SimilarityInput>, ApproximateNearestNeighborsConfig> {
    private static final String DESCRIPTION = "The Approximate Nearest Neighbors algorithm constructs a k-Nearest Neighbors graph for a set of objects based on a provided similarity function.";

    @Procedure(name="gds.alpha.ml.ann.stream", mode=Mode.READ)
    @Description(value="The Approximate Nearest Neighbors algorithm constructs a k-Nearest Neighbors graph for a set of objects based on a provided similarity function.")
    public Stream<SimilarityResult> annStream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.ml.ann.write", mode=Mode.WRITE)
    @Description(value="The Approximate Nearest Neighbors algorithm constructs a k-Nearest Neighbors graph for a set of objects based on a provided similarity function.")
    public Stream<ApproxSimilaritySummaryResult> annWrite(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.writeResult(graphNameOrConfig, configuration);
    }

    protected ApproximateNearestNeighborsConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return new ApproximateNearestNeighborsConfigImpl(graphName, maybeImplicitCreate, username, config);
    }

    @Override
    ApproxNearestNeighborsAlgorithm<SimilarityInput> newAlgo(ApproximateNearestNeighborsConfig config, AllocationTracker tracker) {
        SimilarityAlgorithm<?, ? extends SimilarityInput> similarity = this.similarityAlgorithm(config);
        return new ApproxNearestNeighborsAlgorithm(config, similarity, this.api, this.log, Pools.DEFAULT, tracker);
    }

    SimilarityAlgorithm<?, ? extends SimilarityInput> similarityAlgorithm(ApproximateNearestNeighborsConfig config) {
        switch (config.algorithm()) {
            case jaccard: {
                JaccardConfig jaccardConfig = ImmutableJaccardConfig.builder().from((SimilarityConfig)config).build();
                return new JaccardAlgorithm((SimilarityConfig)jaccardConfig, this.api);
            }
            case cosine: {
                CosineConfig cosineConfig = ImmutableCosineConfig.builder().from((SimilarityConfig)config).build();
                return new CosineAlgorithm(cosineConfig, this.api);
            }
            case pearson: {
                PearsonConfig pearsonConfig = ImmutablePearsonConfig.builder().from((SimilarityConfig)config).build();
                return new PearsonAlgorithm((SimilarityConfig)pearsonConfig, this.api);
            }
            case euclidean: {
                EuclideanConfig euclideanConfig = ImmutableEuclideanConfig.builder().from((SimilarityConfig)config).build();
                return new EuclideanAlgorithm(euclideanConfig, this.api);
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + config.algorithm() + " (sad java \ud83d\ude1e)");
    }

    Stream<ApproxSimilaritySummaryResult> writeResult(Object graphNameOrConfig, Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        ApproximateNearestNeighborsConfig config = (ApproximateNearestNeighborsConfig)computationResult.config();
        SimilarityAlgorithmResult result = (SimilarityAlgorithmResult)computationResult.result();
        assert (result != null);
        if (result.isEmpty()) {
            return this.emptyStreamResult(result, config, (ApproxNearestNeighborsAlgorithm<SimilarityInput>)((ApproxNearestNeighborsAlgorithm)computationResult.algorithm()));
        }
        return this.writeAndAggregateANNResults(result, config, (ApproxNearestNeighborsAlgorithm<SimilarityInput>)((ApproxNearestNeighborsAlgorithm)computationResult.algorithm()));
    }

    private Stream<ApproxSimilaritySummaryResult> emptyStreamResult(SimilarityAlgorithmResult result, ApproximateNearestNeighborsConfig config, @Nullable ApproxNearestNeighborsAlgorithm<SimilarityInput> algorithm) {
        return Stream.of(ApproxSimilaritySummaryResult.from((long)result.nodes(), (long)0L, (long)result.computations().map(Computations::count).orElse(-1L), (String)config.writeRelationshipType(), (String)config.writeProperty(), (long)algorithm.iterations(), (DoubleHistogram)new DoubleHistogram(5)));
    }

    private Stream<ApproxSimilaritySummaryResult> writeAndAggregateANNResults(SimilarityAlgorithmResult algoResult, ApproximateNearestNeighborsConfig config, @Nullable ApproxNearestNeighborsAlgorithm<SimilarityInput> algorithm) {
        AtomicLong similarityPairs = new AtomicLong();
        DoubleHistogram histogram = new DoubleHistogram(5);
        Consumer<SimilarityResult> recorder = result -> {
            result.record(histogram);
            similarityPairs.getAndIncrement();
        };
        SimilarityExporter similarityExporter = new SimilarityExporter(SecureTransaction.of((GraphDatabaseService)this.api), config.writeRelationshipType(), config.writeProperty(), algorithm.getTerminationFlag());
        similarityExporter.export(algoResult.stream().peek(recorder), config.writeBatchSize());
        return Stream.of(ApproxSimilaritySummaryResult.from((long)algoResult.nodes(), (long)similarityPairs.get(), (long)algoResult.computations().map(Computations::count).orElse(-1L), (String)config.writeRelationshipType(), (String)config.writeProperty(), (long)algorithm.iterations(), (DoubleHistogram)histogram));
    }
}

