/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.pregel.SpeakerListenerLPA;
import org.neo4j.gds.pregel.SpeakerListenerLPAAlgorithm;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.beta.pregel.Pregel;
import org.neo4j.graphalgo.beta.pregel.PregelSchema;
import org.neo4j.graphalgo.beta.pregel.PregelStatsProc;
import org.neo4j.graphalgo.beta.pregel.PregelStatsResult;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.progress.ProgressEventTracker;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class SpeakerListenerLPAStatsProc
extends PregelStatsProc<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig> {
    @Procedure(name="gds.alpha.sllpa.stats", mode=Mode.READ)
    @Description(value="The Speaker Listener Label Propagation algorithm is a fast algorithm for finding overlapping communities in a graph.")
    public Stream<PregelStatsResult> stats(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(name="gds.alpha.sllpa.stats.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> statsEstimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected AbstractResultBuilder<PregelStatsResult> resultBuilder(AlgoBaseProc.ComputationResult<SpeakerListenerLPAAlgorithm, Pregel.PregelResult, SpeakerListenerLPA.SpeakerListenerLPAConfig> computeResult) {
        int ranIterations = ((Pregel.PregelResult)computeResult.result()).ranIterations();
        boolean didConverge = ((Pregel.PregelResult)computeResult.result()).didConverge();
        return new PregelStatsResult.Builder().withRanIterations((long)ranIterations).didConverge(didConverge);
    }

    protected SpeakerListenerLPA.SpeakerListenerLPAConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return SpeakerListenerLPA.SpeakerListenerLPAConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig> algorithmFactory() {
        return new AlgorithmFactory<SpeakerListenerLPAAlgorithm, SpeakerListenerLPA.SpeakerListenerLPAConfig>(){

            public SpeakerListenerLPAAlgorithm build(Graph graph, SpeakerListenerLPA.SpeakerListenerLPAConfig configuration, AllocationTracker tracker, Log log, ProgressEventTracker eventTracker) {
                return new SpeakerListenerLPAAlgorithm(graph, configuration, tracker, log);
            }

            public MemoryEstimation memoryEstimation(SpeakerListenerLPA.SpeakerListenerLPAConfig configuration) {
                SpeakerListenerLPA computation = new SpeakerListenerLPA();
                return Pregel.memoryEstimation((PregelSchema)computation.schema(), (boolean)computation.reducer().isPresent());
            }
        };
    }
}

