/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.pregel.Hits;
import org.neo4j.gds.pregel.HitsAlgorithm;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.beta.pregel.Pregel;
import org.neo4j.graphalgo.beta.pregel.PregelMutateProc;
import org.neo4j.graphalgo.beta.pregel.PregelMutateResult;
import org.neo4j.graphalgo.beta.pregel.PregelSchema;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.progress.ProgressEventTracker;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.MemoryEstimateResult;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class HitsMutateProc
extends PregelMutateProc<HitsAlgorithm, Hits.HitsConfig> {
    @Procedure(name="gds.alpha.hits.mutate", mode=Mode.READ)
    @Description(value="Hyperlink-Induced Topic Search (HITS) is a link analysis algorithm that rates nodes")
    public Stream<PregelMutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.mutate(this.compute(graphNameOrConfig, configuration));
    }

    @Procedure(name="gds.alpha.hits.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> mutateEstimate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.computeEstimate(graphNameOrConfig, configuration);
    }

    protected AbstractResultBuilder<PregelMutateResult> resultBuilder(AlgoBaseProc.ComputationResult<HitsAlgorithm, Pregel.PregelResult, Hits.HitsConfig> computeResult) {
        int ranIterations = ((Pregel.PregelResult)computeResult.result()).ranIterations();
        boolean didConverge = ((Pregel.PregelResult)computeResult.result()).didConverge();
        return new PregelMutateResult.Builder().withRanIterations((long)ranIterations).didConverge(didConverge);
    }

    protected Hits.HitsConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return Hits.HitsConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<HitsAlgorithm, Hits.HitsConfig> algorithmFactory() {
        return new AlgorithmFactory<HitsAlgorithm, Hits.HitsConfig>(){

            public HitsAlgorithm build(Graph graph, Hits.HitsConfig configuration, AllocationTracker tracker, Log log, ProgressEventTracker eventTracker) {
                return new HitsAlgorithm(graph, configuration, tracker, log);
            }

            public MemoryEstimation memoryEstimation(Hits.HitsConfig configuration) {
                Hits computation = new Hits();
                return Pregel.memoryEstimation((PregelSchema)computation.schema(), (boolean)computation.reducer().isPresent());
            }
        };
    }
}

