/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.spanningtree;

import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.api.RelationshipProperties;
import org.neo4j.graphalgo.api.nodeproperties.DoubleNodeProperties;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.impl.spanningTrees.KSpanningTree;
import org.neo4j.graphalgo.impl.spanningTrees.Prim;
import org.neo4j.graphalgo.impl.spanningTrees.SpanningTree;
import org.neo4j.graphalgo.spanningtree.KSpanningTreeConfig;
import org.neo4j.graphalgo.utils.InputNodeValidator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class KSpanningTreeProc
extends AlgoBaseProc<KSpanningTree, SpanningTree, KSpanningTreeConfig> {
    private static final String MAX_DESCRIPTION = "The maximum weight spanning tree (MST) starts from a given node, and finds all its reachable nodes and the set of relationships that connect the nodes together with the maximum possible weight.";
    private static final String MIN_DESCRIPTION = "The minimum weight spanning tree (MST) starts from a given node, and finds all its reachable nodes and the set of relationships that connect the nodes together with the minimum possible weight.";
    static DoubleUnaryOperator minMax;
    public static final String DEFAULT_CLUSTER_PROPERTY = "partition";

    @Procedure(value="gds.alpha.spanningTree.kmax.write", mode=Mode.WRITE)
    @Description(value="The maximum weight spanning tree (MST) starts from a given node, and finds all its reachable nodes and the set of relationships that connect the nodes together with the maximum possible weight.")
    public Stream<Prim.Result> kmax(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        minMax = Prim.MAX_OPERATOR;
        return this.computeAndWrite(graphNameOrConfig, configuration);
    }

    @Procedure(value="gds.alpha.spanningTree.kmin.write", mode=Mode.WRITE)
    @Description(value="The minimum weight spanning tree (MST) starts from a given node, and finds all its reachable nodes and the set of relationships that connect the nodes together with the minimum possible weight.")
    public Stream<Prim.Result> kmin(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        minMax = Prim.MIN_OPERATOR;
        return this.computeAndWrite(graphNameOrConfig, configuration);
    }

    public Stream<Prim.Result> computeAndWrite(Object graphNameOrConfig, Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        Graph graph = computationResult.graph();
        SpanningTree spanningTree = (SpanningTree)computationResult.result();
        KSpanningTreeConfig config = (KSpanningTreeConfig)computationResult.config();
        Prim.Builder builder = new Prim.Builder();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of(builder.build());
        }
        builder.withEffectiveNodeCount(spanningTree.effectiveNodeCount);
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((Prim.Builder)builder).withWriteMillis(arg_0));){
            NodePropertyExporter exporter = (NodePropertyExporter)NodePropertyExporter.builder((GraphDatabaseService)this.api, (IdMapping)graph, (TerminationFlag)TerminationFlag.wrap((KernelTransaction)this.transaction)).withLog(this.log).parallel(Pools.DEFAULT, config.writeConcurrency()).build();
            exporter.write(config.writeProperty(), (NodeProperties)((DoubleNodeProperties)nodeId -> spanningTree.head((int)nodeId)));
            builder.withNodePropertiesWritten(exporter.propertiesWritten());
        }
        builder.withComputeMillis(computationResult.computeMillis());
        builder.withCreateMillis(computationResult.createMillis());
        return Stream.of(builder.build());
    }

    protected KSpanningTreeConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return KSpanningTreeConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<KSpanningTree, KSpanningTreeConfig> algorithmFactory() {
        return (graph, configuration, tracker, log) -> {
            InputNodeValidator.validateStartNode(configuration.startNodeId(), graph);
            return new KSpanningTree((IdMapping)graph, graph, (RelationshipProperties)graph, minMax, configuration.startNodeId(), configuration.k());
        };
    }
}

