/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.shortestpaths.ShortestPathAStarConfig;
import org.neo4j.graphdb.Node;

public final class ShortestPathAStarConfigImpl
implements ShortestPathAStarConfig {
    private String propertyKeyLat;
    private String propertyKeyLon;
    private long startNodeId;
    private long endNodeId;
    private Optional<String> graphName;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    private Optional<GraphCreateConfig> implicitCreateConfig;
    private String username;
    private boolean sudo;
    private int concurrency;
    @Nullable
    private String relationshipWeightProperty;

    public ShortestPathAStarConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.propertyKeyLat = (String)CypherMapWrapper.failOnNull((String)"propertyKeyLat", (Object)config.getString("propertyKeyLat", ShortestPathAStarConfig.super.propertyKeyLat()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.propertyKeyLon = (String)CypherMapWrapper.failOnNull((String)"propertyKeyLon", (Object)config.getString("propertyKeyLon", ShortestPathAStarConfig.super.propertyKeyLon()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.startNodeId = ShortestPathAStarConfig.nodeId((Node)config.requireChecked("startNode", Node.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.endNodeId = ShortestPathAStarConfig.nodeId((Node)config.requireChecked("endNode", Node.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)ShortestPathAStarConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)ShortestPathAStarConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", ShortestPathAStarConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", ShortestPathAStarConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = StringUtils.trimToNull((String)config.getString("relationshipWeightProperty", ShortestPathAStarConfig.super.relationshipWeightProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public String propertyKeyLat() {
        return this.propertyKeyLat;
    }

    @Override
    public String propertyKeyLon() {
        return this.propertyKeyLon;
    }

    @Override
    public long startNodeId() {
        return this.startNodeId;
    }

    @Override
    public long endNodeId() {
        return this.endNodeId;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("propertyKeyLat", "propertyKeyLon", "startNode", "endNode", "relationshipTypes", "nodeLabels", "sudo", "concurrency", "relationshipWeightProperty");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("propertyKeyLat", this.propertyKeyLat());
        map.put("propertyKeyLon", this.propertyKeyLon());
        map.put("startNode", this.startNodeId());
        map.put("endNode", this.endNodeId());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }
}

