/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality.eigenvector;

import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.centrality.eigenvector.EigenvectorCentralityConfig;
import org.neo4j.graphalgo.centrality.eigenvector.ImmutableEigenvectorCentralityConfig;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.BatchingProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.pagerank.LabsPageRankAlgorithmType;
import org.neo4j.graphalgo.pagerank.PageRank;
import org.neo4j.graphalgo.pagerank.PageRankBaseConfig;
import org.neo4j.logging.Log;

class EigenvectorCentralityAlgorithmFactory
implements AlphaAlgorithmFactory<PageRank, EigenvectorCentralityConfig> {
    EigenvectorCentralityAlgorithmFactory() {
    }

    @Override
    public PageRank build(Graph graph, EigenvectorCentralityConfig configuration, AllocationTracker tracker, Log log) {
        return this.buildAlphaAlgo(graph, configuration, tracker, log);
    }

    @Override
    public PageRank buildAlphaAlgo(Graph graph, EigenvectorCentralityConfig configuration, AllocationTracker tracker, Log log) {
        configuration = ImmutableEigenvectorCentralityConfig.builder().from(configuration).dampingFactor(1.0).build();
        return LabsPageRankAlgorithmType.EIGENVECTOR_CENTRALITY.create(graph, configuration.sourceNodeIds(), (PageRankBaseConfig)configuration, Pools.DEFAULT, (ProgressLogger)new BatchingProgressLogger(log, 0L, "PageRank", configuration.concurrency()), tracker);
    }
}

