/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.walking;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.collections.api.tuple.Pair;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.ImmutableComputationResult;
import org.neo4j.graphalgo.MutateProc;
import org.neo4j.graphalgo.RelationshipType;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.GraphStore;
import org.neo4j.graphalgo.api.Relationships;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.impl.walking.TraversalToRelationship;
import org.neo4j.graphalgo.impl.walking.TraversalToRelationshipConfig;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class TraversalToRelationshipMutateProc
extends MutateProc<TraversalToRelationship, Relationships, MutateResult, TraversalToRelationshipConfig> {
    @Procedure(name="gds.alpha.traversalToRelationship.mutate", mode=Mode.READ)
    @Description(value="")
    public Stream<MutateResult> mutate(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult<TraversalToRelationship, Relationships, TraversalToRelationshipConfig> computationResult = this.compute(graphNameOrConfig, configuration, true, false);
        return this.mutate(computationResult);
    }

    protected AlgoBaseProc.ComputationResult<TraversalToRelationship, Relationships, TraversalToRelationshipConfig> compute(Object graphNameOrConfig, Map<String, Object> configuration, boolean releaseAlgorithm, boolean releaseTopology) {
        GraphStore graphStore;
        ImmutableComputationResult.Builder builder = ImmutableComputationResult.builder();
        Pair input = this.processInput(graphNameOrConfig, configuration);
        TraversalToRelationshipConfig config = (TraversalToRelationshipConfig)input.getOne();
        try (ProgressTimer timer = ProgressTimer.start(arg_0 -> ((ImmutableComputationResult.Builder)builder).createMillis(arg_0));){
            graphStore = this.getOrCreateGraphStore(input);
        }
        Graph[] graphs = (Graph[])config.relationshipTypes().stream().map(relType -> graphStore.getGraph(new RelationshipType[]{RelationshipType.of((String)relType)})).toArray(Graph[]::new);
        AllocationTracker tracker = this.allocationTracker();
        TraversalToRelationship algo = new TraversalToRelationship(graphs, config, Pools.DEFAULT, tracker);
        builder.algorithm((Algorithm)algo);
        try (ProgressTimer timer = ProgressTimer.start(arg_0 -> ((ImmutableComputationResult.Builder)builder).computeMillis(arg_0));){
            builder.result((Object)algo.compute());
        }
        this.log.info(this.algoName() + ": overall memory usage %s", new Object[]{tracker.getUsageString()});
        algo.release();
        for (Graph graph : graphs) {
            graph.releaseTopology();
        }
        return builder.graphStore(graphStore).graph(graphs[0]).algorithm((Algorithm)algo).config((AlgoBaseConfig)config).build();
    }

    protected TraversalToRelationshipConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return TraversalToRelationshipConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, AlgoBaseProc.ComputationResult<TraversalToRelationship, Relationships, TraversalToRelationshipConfig> computationResult) {
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withMutateMillis(arg_0));){
            computationResult.graphStore().addRelationshipType(RelationshipType.of((String)((TraversalToRelationshipConfig)computationResult.config()).mutateRelationshipType()), Optional.empty(), Optional.empty(), (Relationships)computationResult.result());
        }
        resultBuilder.withRelationshipsWritten(((Relationships)computationResult.result()).topology().elementCount());
    }

    protected AlgorithmFactory<TraversalToRelationship, TraversalToRelationshipConfig> algorithmFactory() {
        throw new UnsupportedOperationException("TraversalToRelationship does not support the AlgorithmFactory");
    }

    protected AbstractResultBuilder<MutateResult> resultBuilder(AlgoBaseProc.ComputationResult<TraversalToRelationship, Relationships, TraversalToRelationshipConfig> computeResult) {
        return new MutateResult.Builder();
    }

    public static class MutateResult {
        public final long createMillis;
        public final long computeMillis;
        public final long mutateMillis;
        public final long relationshipsWritten;
        public final Map<String, Object> configuration;

        MutateResult(long createMillis, long computeMillis, long mutateMillis, long relationshipsWritten, Map<String, Object> configuration) {
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.mutateMillis = mutateMillis;
            this.relationshipsWritten = relationshipsWritten;
            this.configuration = configuration;
        }

        static class Builder
        extends AbstractResultBuilder<MutateResult> {
            Builder() {
            }

            public MutateResult build() {
                return new MutateResult(this.createMillis, this.computeMillis, this.mutateMillis, this.relationshipsWritten, this.config.toMap());
            }
        }
    }
}

