/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.similarity;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.impl.similarity.EuclideanAlgorithm;
import org.neo4j.graphalgo.impl.similarity.EuclideanConfig;
import org.neo4j.graphalgo.impl.similarity.EuclideanConfigImpl;
import org.neo4j.graphalgo.results.SimilarityResult;
import org.neo4j.graphalgo.results.SimilarityStatsResult;
import org.neo4j.graphalgo.results.SimilaritySummaryResult;
import org.neo4j.graphalgo.similarity.SimilarityProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class EuclideanProc
extends SimilarityProc<EuclideanAlgorithm, EuclideanConfig> {
    private static final String DESCRIPTION = "Euclidean-similarity is an algorithm for finding similar nodes based on the euclidean distance.";

    @Procedure(name="gds.alpha.similarity.euclidean.stream", mode=Mode.READ)
    @Description(value="Euclidean-similarity is an algorithm for finding similar nodes based on the euclidean distance.")
    public Stream<SimilarityResult> euclideanStream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.euclidean.write", mode=Mode.WRITE)
    @Description(value="Euclidean-similarity is an algorithm for finding similar nodes based on the euclidean distance.")
    public Stream<SimilaritySummaryResult> euclideanWrite(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.euclidean.stats", mode=Mode.READ)
    @Description(value="Euclidean-similarity is an algorithm for finding similar nodes based on the euclidean distance.")
    public Stream<SimilarityStatsResult> euclideanStats(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats(graphNameOrConfig, configuration);
    }

    protected EuclideanConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper userInput) {
        return new EuclideanConfigImpl(graphName, maybeImplicitCreate, username, userInput);
    }

    @Override
    EuclideanAlgorithm newAlgo(EuclideanConfig config, AllocationTracker tracker) {
        return new EuclideanAlgorithm(config, this.api);
    }
}

