/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import java.util.Map;
import java.util.Optional;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.api.nodeproperties.DoubleNodeProperties;
import org.neo4j.graphalgo.centrality.AsUndirected;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.impl.closeness.HarmonicCentralityConfig;
import org.neo4j.graphalgo.impl.harmonic.HarmonicCentrality;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.CentralityScore;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class HarmonicCentralityProc
extends AlgoBaseProc<HarmonicCentrality, HarmonicCentrality, HarmonicCentralityConfig> {
    private static final String DESCRIPTION = "Harmonic centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.";

    @Procedure(name="gds.alpha.closeness.harmonic.stream", mode=Mode.READ)
    @Description(value="Harmonic centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<StreamResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        HarmonicCentrality algorithm = (HarmonicCentrality)computationResult.algorithm();
        Graph graph = computationResult.graph();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.empty();
        }
        return LongStream.range(0L, graph.nodeCount()).boxed().map(nodeId -> new StreamResult(graph.toOriginalNodeId(nodeId.longValue()), algorithm.getCentralityScore(nodeId.longValue())));
    }

    @Procedure(value="gds.alpha.closeness.harmonic.write", mode=Mode.WRITE)
    @Description(value="Harmonic centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<CentralityScore.Stats> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        HarmonicCentrality algorithm = (HarmonicCentrality)computationResult.algorithm();
        HarmonicCentralityConfig config = (HarmonicCentralityConfig)computationResult.config();
        Graph graph = computationResult.graph();
        AbstractResultBuilder builder = new CentralityScore.Stats.Builder().withNodeCount(graph.nodeCount()).withConfig((AlgoBaseConfig)config).withComputeMillis(computationResult.computeMillis()).withCreateMillis(computationResult.createMillis());
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of((CentralityScore.Stats)builder.build());
        }
        try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((AbstractResultBuilder)builder).withWriteMillis(arg_0));){
            NodePropertyExporter exporter = (NodePropertyExporter)NodePropertyExporter.builder((GraphDatabaseService)this.api, (IdMapping)graph, (TerminationFlag)algorithm.getTerminationFlag()).withLog(this.log).parallel(Pools.DEFAULT, ((HarmonicCentralityConfig)computationResult.config()).writeConcurrency()).build();
            exporter.write(config.writeProperty(), (NodeProperties)((DoubleNodeProperties)arg_0 -> ((HarmonicCentrality)((HarmonicCentrality)computationResult.result())).getCentralityScore(arg_0)));
        }
        return Stream.of((CentralityScore.Stats)builder.build());
    }

    protected HarmonicCentralityConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return HarmonicCentralityConfig.of(graphName, maybeImplicitCreate.map(AsUndirected::rewrite), (String)username, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<HarmonicCentrality, HarmonicCentralityConfig> algorithmFactory() {
        return (graph, configuration, tracker, log) -> new HarmonicCentrality(graph, tracker, configuration.concurrency(), Pools.DEFAULT);
    }

    public static final class StreamResult {
        public final long nodeId;
        public final double centrality;

        StreamResult(long nodeId, double centrality) {
            this.nodeId = nodeId;
            this.centrality = centrality;
        }
    }
}

