/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.centrality.ArticleRankConfig;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.BatchingProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.mem.AllocationTracker;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.pagerank.LabsPageRankAlgorithmType;
import org.neo4j.graphalgo.pagerank.PageRank;
import org.neo4j.graphalgo.pagerank.PageRankBaseConfig;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.CentralityScore;
import org.neo4j.graphalgo.results.PageRankScore;
import org.neo4j.graphalgo.utils.CentralityUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class ArticleRankProc
extends AlgoBaseProc<PageRank, PageRank, ArticleRankConfig> {
    private static final String DESCRIPTION = "ArticleRank is a variant of the Page Rank algorithm, which measures the transitive influence or connectivity of nodes.";

    @Procedure(value="gds.alpha.articleRank.write", mode=Mode.WRITE)
    @Description(value="ArticleRank is a variant of the Page Rank algorithm, which measures the transitive influence or connectivity of nodes.")
    public Stream<PageRankScore.Stats> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        PageRank algo = (PageRank)computationResult.algorithm();
        ArticleRankConfig config = (ArticleRankConfig)computationResult.config();
        AllocationTracker tracker = computationResult.tracker();
        Graph graph = computationResult.graph();
        AbstractResultBuilder statsBuilder = new PageRankScore.Stats.Builder().withConfig((AlgoBaseConfig)config).withCreateMillis(computationResult.createMillis()).withComputeMillis(computationResult.computeMillis());
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of((PageRankScore.Stats)statsBuilder.build());
        }
        this.log.info("ArticleRank: overall memory usage: %s", new Object[]{tracker.getUsageString()});
        try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((AbstractResultBuilder)statsBuilder).withWriteMillis(arg_0));){
            NodePropertyExporter exporter = (NodePropertyExporter)NodePropertyExporter.builder((GraphDatabaseService)this.api, (IdMapping)graph, (TerminationFlag)algo.getTerminationFlag()).withLog(this.log).parallel(Pools.DEFAULT, config.writeConcurrency()).build();
            algo.result().export(config.writeProperty(), exporter);
        }
        graph.release();
        return Stream.of((PageRankScore.Stats)statsBuilder.build());
    }

    @Procedure(value="gds.alpha.articleRank.stream", mode=Mode.READ)
    @Description(value="ArticleRank is a variant of the Page Rank algorithm, which measures the transitive influence or connectivity of nodes.")
    public Stream<CentralityScore> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        PageRank algo = (PageRank)computationResult.algorithm();
        AllocationTracker tracker = computationResult.tracker();
        Graph graph = computationResult.graph();
        if (computationResult.graph().isEmpty()) {
            return Stream.empty();
        }
        this.log.info("ArticleRank: overall memory usage: %s", new Object[]{tracker.getUsageString()});
        return CentralityUtils.streamResults(graph, algo.result());
    }

    protected ArticleRankConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper userInput) {
        return ArticleRankConfig.of(username, graphName, maybeImplicitCreate, userInput);
    }

    protected AlgorithmFactory<PageRank, ArticleRankConfig> algorithmFactory() {
        return new AlphaAlgorithmFactory<PageRank, ArticleRankConfig>(){

            @Override
            public PageRank build(Graph graph, ArticleRankConfig configuration, AllocationTracker tracker, Log log) {
                return this.buildAlphaAlgo(graph, configuration, tracker, log);
            }

            @Override
            public PageRank buildAlphaAlgo(Graph graph, ArticleRankConfig configuration, AllocationTracker tracker, Log log) {
                return LabsPageRankAlgorithmType.ARTICLE_RANK.create(graph, configuration.sourceNodeIds(), (PageRankBaseConfig)configuration, Pools.DEFAULT, (ProgressLogger)new BatchingProgressLogger((Log)NullLog.getInstance(), 0L, "PageRank", configuration.concurrency()), tracker);
            }
        };
    }
}

