/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.similarity;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.HdrHistogram.DoubleHistogram;
import org.eclipse.collections.api.tuple.Pair;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.NodeProjections;
import org.neo4j.graphalgo.RelationshipProjections;
import org.neo4j.graphalgo.api.GraphStore;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.ImmutableGraphCreateFromStoreConfig;
import org.neo4j.graphalgo.core.SecureTransaction;
import org.neo4j.graphalgo.core.loading.GraphStoreCatalog;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.impl.similarity.Computations;
import org.neo4j.graphalgo.impl.similarity.SimilarityAlgorithm;
import org.neo4j.graphalgo.impl.similarity.SimilarityAlgorithmResult;
import org.neo4j.graphalgo.impl.similarity.SimilarityConfig;
import org.neo4j.graphalgo.results.SimilarityExporter;
import org.neo4j.graphalgo.results.SimilarityResult;
import org.neo4j.graphalgo.results.SimilarityStatsResult;
import org.neo4j.graphalgo.results.SimilaritySummaryResult;
import org.neo4j.graphalgo.similarity.nil.NullGraphStore;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.database.NamedDatabaseId;

abstract class SimilarityProc<ALGO extends SimilarityAlgorithm<ALGO, ?>, CONFIG extends SimilarityConfig>
extends AlgoBaseProc<ALGO, SimilarityAlgorithmResult, CONFIG> {
    public static final String SIMILARITY_FAKE_GRAPH_NAME = "  SIM-NULL-GRAPH";

    SimilarityProc() {
    }

    Stream<SimilarityResult> stream(Object graphNameOrConfig, Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult compute = this.compute(graphNameOrConfig, configuration);
        SimilarityAlgorithmResult result = (SimilarityAlgorithmResult)compute.result();
        assert (result != null);
        return result.stream();
    }

    Stream<SimilaritySummaryResult> write(Object graphNameOrConfig, Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult compute = this.compute(graphNameOrConfig, configuration);
        SimilarityConfig config = (SimilarityConfig)compute.config();
        SimilarityAlgorithmResult result = (SimilarityAlgorithmResult)compute.result();
        assert (result != null);
        if (result.isEmpty()) {
            return this.emptyStream(config.writeRelationshipType(), config.writeProperty());
        }
        return this.writeAndAggregateResults(result, config, ((SimilarityAlgorithm)compute.algorithm()).getTerminationFlag());
    }

    Stream<SimilarityStatsResult> stats(Object graphNameOrConfig, Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult compute = this.compute(graphNameOrConfig, configuration);
        SimilarityAlgorithmResult result = (SimilarityAlgorithmResult)compute.result();
        assert (result != null);
        if (result.isEmpty()) {
            return Stream.of(SimilarityStatsResult.from((long)0L, (long)0L, (long)0L, (AtomicLong)new AtomicLong(0L), (long)-1L, (DoubleHistogram)new DoubleHistogram(5)));
        }
        AtomicLong similarityPairs = new AtomicLong();
        DoubleHistogram histogram = new DoubleHistogram(5);
        result.stream().forEach(recorder -> {
            recorder.record(histogram);
            similarityPairs.getAndIncrement();
        });
        return Stream.of(SimilarityStatsResult.from((long)result.nodes(), (long)result.sourceIdsLength(), (long)result.targetIdsLength(), (AtomicLong)similarityPairs, (long)result.computations().map(Computations::count).orElse(-1L), (DoubleHistogram)histogram));
    }

    abstract ALGO newAlgo(CONFIG var1);

    protected final AlgorithmFactory<ALGO, CONFIG> algorithmFactory() {
        return (graph, configuration, tracker, log) -> {
            this.removeGraph();
            return this.newAlgo(configuration);
        };
    }

    protected Pair<CONFIG, Optional<String>> processInput(Object graphNameOrConfig, Map<String, Object> configuration) {
        if (graphNameOrConfig instanceof String) {
            throw new IllegalArgumentException("Similarity algorithms do not support named graphs");
        }
        if (graphNameOrConfig instanceof Map) {
            Map configMap = (Map)graphNameOrConfig;
            graphNameOrConfig = SIMILARITY_FAKE_GRAPH_NAME;
            configuration = configMap;
            configuration.remove("nodeQuery");
            configuration.remove("relationshipQuery");
            configuration.remove("nodeProjection");
            configuration.remove("relationshipProjection");
            GraphStoreCatalog.set((GraphCreateConfig)ImmutableGraphCreateFromStoreConfig.of((String)this.username(), (String)graphNameOrConfig.toString(), (NodeProjections)NodeProjections.ALL, (RelationshipProjections)RelationshipProjections.ALL), (GraphStore)new NullGraphStore(this.databaseId()));
        }
        try {
            return super.processInput(graphNameOrConfig, configuration);
        }
        catch (RuntimeException e) {
            this.removeGraph();
            throw e;
        }
    }

    private void removeGraph() {
        GraphStoreCatalog.remove((String)this.username(), (NamedDatabaseId)this.databaseId(), (String)SIMILARITY_FAKE_GRAPH_NAME, gsc -> {});
    }

    private Stream<SimilaritySummaryResult> emptyStream(String writeRelationshipType, String writeProperty) {
        return Stream.of(SimilaritySummaryResult.from((long)0L, (long)0L, (long)0L, (AtomicLong)new AtomicLong(0L), (long)-1L, (String)writeRelationshipType, (String)writeProperty, (DoubleHistogram)new DoubleHistogram(5)));
    }

    private Stream<SimilaritySummaryResult> writeAndAggregateResults(SimilarityAlgorithmResult algoResult, CONFIG config, TerminationFlag terminationFlag) {
        AtomicLong similarityPairs = new AtomicLong();
        DoubleHistogram histogram = new DoubleHistogram(5);
        Consumer<SimilarityResult> recorder = result -> {
            result.record(histogram);
            similarityPairs.getAndIncrement();
        };
        SimilarityExporter similarityExporter = new SimilarityExporter(SecureTransaction.of((GraphDatabaseService)this.api), config.writeRelationshipType(), config.writeProperty(), terminationFlag);
        similarityExporter.export(algoResult.stream().peek(recorder), config.writeBatchSize());
        return Stream.of(SimilaritySummaryResult.from((long)algoResult.nodes(), (long)algoResult.sourceIdsLength(), (long)algoResult.targetIdsLength(), (AtomicLong)similarityPairs, (long)algoResult.computations().map(Computations::count).orElse(-1L), (String)config.writeRelationshipType(), (String)config.writeProperty(), (DoubleHistogram)histogram));
    }
}

