/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.similarity;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.impl.similarity.PearsonAlgorithm;
import org.neo4j.graphalgo.impl.similarity.PearsonConfig;
import org.neo4j.graphalgo.impl.similarity.PearsonConfigImpl;
import org.neo4j.graphalgo.impl.similarity.SimilarityConfig;
import org.neo4j.graphalgo.results.SimilarityResult;
import org.neo4j.graphalgo.results.SimilarityStatsResult;
import org.neo4j.graphalgo.results.SimilaritySummaryResult;
import org.neo4j.graphalgo.similarity.SimilarityProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class PearsonProc
extends SimilarityProc<PearsonAlgorithm, PearsonConfig> {
    private static final String DESCRIPTION = "Pearson-similarity is an algorithm for finding similar nodes based on the pearson correlation coefficient.";

    @Procedure(name="gds.alpha.similarity.pearson.stream", mode=Mode.READ)
    @Description(value="Pearson-similarity is an algorithm for finding similar nodes based on the pearson correlation coefficient.")
    public Stream<SimilarityResult> pearsonStream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.pearson.write", mode=Mode.WRITE)
    @Description(value="Pearson-similarity is an algorithm for finding similar nodes based on the pearson correlation coefficient.")
    public Stream<SimilaritySummaryResult> pearsonWrite(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.similarity.pearson.stats", mode=Mode.WRITE)
    @Description(value="Pearson-similarity is an algorithm for finding similar nodes based on the pearson correlation coefficient.")
    public Stream<SimilarityStatsResult> pearsonStats(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats(graphNameOrConfig, configuration);
    }

    protected PearsonConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper userInput) {
        return new PearsonConfigImpl(graphName, maybeImplicitCreate, username, userInput);
    }

    @Override
    PearsonAlgorithm newAlgo(PearsonConfig config) {
        return new PearsonAlgorithm((SimilarityConfig)config, this.api);
    }
}

