/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.centrality.ArticleRankConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphdb.Node;

public final class ArticleRankConfigImpl
implements ArticleRankConfig {
    private String writeProperty;
    private double tolerance;
    private int maxIterations;
    private double dampingFactor;
    private boolean cacheWeights;
    private Optional<String> graphName;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    private Optional<GraphCreateConfig> implicitCreateConfig;
    private String username;
    private boolean sudo;
    private int concurrency;
    @Nullable
    private String relationshipWeightProperty;
    private List<Node> sourceNodes;
    private int writeConcurrency;

    public ArticleRankConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)config.getString("writeProperty", ArticleRankConfig.super.writeProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.tolerance = config.getDouble("tolerance", ArticleRankConfig.super.tolerance());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxIterations = config.getInt("maxIterations", ArticleRankConfig.super.maxIterations());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.dampingFactor = config.getDouble("dampingFactor", ArticleRankConfig.super.dampingFactor());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.cacheWeights = config.getBool("cacheWeights", ArticleRankConfig.super.cacheWeights());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)ArticleRankConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)ArticleRankConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", ArticleRankConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", ArticleRankConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = StringUtils.trimToNull((String)config.getString("relationshipWeightProperty", ArticleRankConfig.super.relationshipWeightProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sourceNodes = (List)CypherMapWrapper.failOnNull((String)"sourceNodes", (Object)((List)config.getChecked("sourceNodes", (Object)ArticleRankConfig.super.sourceNodes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.writeConcurrency = config.getInt("writeConcurrency", ArticleRankConfig.super.writeConcurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateWriteConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public String writeProperty() {
        return this.writeProperty;
    }

    public double tolerance() {
        return this.tolerance;
    }

    public int maxIterations() {
        return this.maxIterations;
    }

    public double dampingFactor() {
        return this.dampingFactor;
    }

    public boolean cacheWeights() {
        return this.cacheWeights;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("writeProperty", "tolerance", "maxIterations", "dampingFactor", "cacheWeights", "relationshipTypes", "nodeLabels", "sudo", "concurrency", "relationshipWeightProperty", "sourceNodes", "writeConcurrency");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("writeProperty", this.writeProperty());
        map.put("tolerance", this.tolerance());
        map.put("maxIterations", this.maxIterations());
        map.put("dampingFactor", this.dampingFactor());
        map.put("cacheWeights", this.cacheWeights());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("sudo", this.sudo());
        map.put("concurrency", this.concurrency());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        map.put("sourceNodes", this.sourceNodes());
        map.put("writeConcurrency", this.writeConcurrency());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public List<Node> sourceNodes() {
        return this.sourceNodes;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }
}

