/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressLoggerAdapter;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.exceptions.MemoryEstimationNotImplementedException;
import org.neo4j.logging.Log;

public abstract class AlphaAlgorithmFactory<ALGO extends Algorithm<ALGO, ?>, CONFIG extends AlgoBaseConfig>
extends AlgorithmFactory<ALGO, CONFIG> {
    public ALGO build(Graph graph, CONFIG configuration, AllocationTracker tracker, Log log) {
        ALGO algo = this.buildAlphaAlgo(graph, configuration, tracker, log);
        return (ALGO)algo.withProgressLogger((ProgressLogger)new ProgressLoggerAdapter(log, algo.getClass().getSimpleName()));
    }

    public abstract ALGO buildAlphaAlgo(Graph var1, CONFIG var2, AllocationTracker var3, Log var4);

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        throw new MemoryEstimationNotImplementedException();
    }
}

