/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpaths;

import com.carrotsearch.hppc.IntDoubleMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.core.write.PropertyTranslator;
import org.neo4j.graphalgo.core.write.Translators;
import org.neo4j.graphalgo.impl.shortestpaths.ShortestPaths;
import org.neo4j.graphalgo.results.ShortestPathResult;
import org.neo4j.graphalgo.shortestpaths.ShortestPathsConfig;
import org.neo4j.graphalgo.utils.InputNodeValidator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ShortestPathsProc
extends AlgoBaseProc<ShortestPaths, ShortestPaths, ShortestPathsConfig> {
    private static final String DESCRIPTION = "The Shortest Path algorithm calculates the shortest (weighted) path between a pair of nodes.";

    @Procedure(name="gds.alpha.shortestPaths.stream", mode=Mode.READ)
    @Description(value="The Shortest Path algorithm calculates the shortest (weighted) path between a pair of nodes.")
    public Stream<ShortestPaths.Result> dijkstraStream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        if (computationResult.graph().isEmpty()) {
            return Stream.empty();
        }
        return ((ShortestPaths)computationResult.algorithm()).resultStream();
    }

    @Procedure(value="gds.alpha.shortestPaths.write", mode=Mode.WRITE)
    @Description(value="The Shortest Path algorithm calculates the shortest (weighted) path between a pair of nodes.")
    public Stream<ShortestPathResult> dijkstra(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        ShortestPaths algorithm = (ShortestPaths)computationResult.algorithm();
        ShortestPathResult.Builder builder = ShortestPathResult.builder();
        try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((ShortestPathResult.Builder)builder).withWriteMillis(arg_0));){
            IntDoubleMap shortestPaths = algorithm.getShortestPaths();
            algorithm.release();
            ShortestPathsConfig config = (ShortestPathsConfig)computationResult.config();
            ((NodePropertyExporter)NodePropertyExporter.builder((GraphDatabaseService)this.api, (IdMapping)computationResult.graph(), (TerminationFlag)algorithm.getTerminationFlag()).withLog(this.log).parallel(Pools.DEFAULT, config.writeConcurrency()).build()).write(config.writeProperty(), (Object)shortestPaths, (PropertyTranslator)Translators.INT_DOUBLE_MAP_TRANSLATOR);
        }
        return Stream.of(builder.build());
    }

    protected ShortestPathsConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ShortestPathsConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<ShortestPaths, ShortestPathsConfig> algorithmFactory(final ShortestPathsConfig config) {
        return new AlphaAlgorithmFactory<ShortestPaths, ShortestPathsConfig>(){

            @Override
            public ShortestPaths buildAlphaAlgo(Graph graph, ShortestPathsConfig configuration, AllocationTracker tracker, Log log) {
                InputNodeValidator.validateStartNode(configuration.startNode(), graph);
                return new ShortestPaths(graph, config.startNode());
            }
        };
    }
}

