/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpaths;

import com.carrotsearch.hppc.IntArrayDeque;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.core.write.PropertyTranslator;
import org.neo4j.graphalgo.core.write.Translators;
import org.neo4j.graphalgo.impl.shortestpaths.DijkstraConfig;
import org.neo4j.graphalgo.impl.shortestpaths.ShortestPathDijkstra;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.utils.InputNodeValidator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class DijkstraProc
extends AlgoBaseProc<ShortestPathDijkstra, ShortestPathDijkstra, DijkstraConfig> {
    private static final String DESCRIPTION = "The Shortest Path algorithm calculates the shortest (weighted) path between a pair of nodes using the Dijkstra algorithm.";

    @Procedure(name="gds.alpha.shortestPath.stream", mode=Mode.READ)
    @Description(value="The Shortest Path algorithm calculates the shortest (weighted) path between a pair of nodes using the Dijkstra algorithm.")
    public Stream<ShortestPathDijkstra.Result> dijkstraStream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        return ((ShortestPathDijkstra)computationResult.algorithm()).resultStream();
    }

    @Procedure(value="gds.alpha.shortestPath.write", mode=Mode.WRITE)
    @Description(value="The Shortest Path algorithm calculates the shortest (weighted) path between a pair of nodes using the Dijkstra algorithm.")
    public Stream<DijkstraResult> dijkstraWrite(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        DijkstraResult.Builder builder = DijkstraResult.builder();
        builder.withCreateMillis(computationResult.createMillis());
        builder.withComputeMillis(computationResult.computeMillis());
        Graph graph = computationResult.graph();
        ShortestPathDijkstra dijkstra = (ShortestPathDijkstra)computationResult.algorithm();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of(builder.build());
        }
        builder.withNodeCount(dijkstra.getPathLength()).withTotalCosts(dijkstra.getTotalCost());
        try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((DijkstraResult.Builder)builder).withWriteMillis(arg_0));){
            IntArrayDeque finalPath = dijkstra.getFinalPath();
            double[] finalPathCost = dijkstra.getFinalPathCosts();
            dijkstra.release();
            DequeMapping mapping = new DequeMapping((IdMapping)graph, finalPath);
            ((NodePropertyExporter)NodePropertyExporter.builder((GraphDatabaseService)this.api, (IdMapping)mapping, (TerminationFlag)dijkstra.getTerminationFlag()).withLog(this.log).build()).write(((DijkstraConfig)computationResult.config()).writeProperty(), (Object)finalPathCost, (PropertyTranslator)Translators.DOUBLE_ARRAY_TRANSLATOR);
        }
        graph.release();
        return Stream.of(builder.build());
    }

    protected DijkstraConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper userInput) {
        return DijkstraConfig.of(graphName, maybeImplicitCreate, (String)username, (CypherMapWrapper)userInput);
    }

    protected AlgorithmFactory<ShortestPathDijkstra, DijkstraConfig> algorithmFactory(final DijkstraConfig config) {
        return new AlphaAlgorithmFactory<ShortestPathDijkstra, DijkstraConfig>(){

            @Override
            public ShortestPathDijkstra buildAlphaAlgo(Graph graph, DijkstraConfig configuration, AllocationTracker tracker, Log log) {
                InputNodeValidator.validateStartNode(config.startNode(), graph);
                InputNodeValidator.validateEndNode(config.endNode(), graph);
                return new ShortestPathDijkstra(graph, configuration);
            }
        };
    }

    public static class DijkstraResult {
        public final long createMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final long nodeCount;
        public final double totalCost;

        public DijkstraResult(long createMillis, long computeMillis, long writeMillis, long nodeCount, double totalCost) {
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.nodeCount = nodeCount;
            this.totalCost = totalCost;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends AbstractResultBuilder<DijkstraResult> {
            protected long nodeCount = 0L;
            protected double totalCosts = 0.0;

            public Builder withNodeCount(long nodeCount) {
                this.nodeCount = nodeCount;
                return this;
            }

            public Builder withTotalCosts(double totalCosts) {
                this.totalCosts = totalCosts;
                return this;
            }

            public DijkstraResult build() {
                return new DijkstraResult(this.createMillis, this.computeMillis, this.writeMillis, this.nodeCount, this.totalCosts);
            }
        }
    }

    private static final class DequeMapping
    implements IdMapping {
        private final IdMapping mapping;
        private final int[] data;
        private final int offset;
        private final int length;

        private DequeMapping(IdMapping mapping, IntArrayDeque data) {
            this.mapping = mapping;
            if (data.head <= data.tail) {
                this.data = data.buffer;
                this.offset = data.head;
                this.length = data.tail - data.head;
            } else {
                this.data = data.toArray();
                this.offset = 0;
                this.length = this.data.length;
            }
        }

        public long toMappedNodeId(long nodeId) {
            return this.mapping.toMappedNodeId(nodeId);
        }

        public long toOriginalNodeId(long nodeId) {
            assert (nodeId < (long)this.length);
            return this.mapping.toOriginalNodeId((long)this.data[this.offset + Math.toIntExact(nodeId)]);
        }

        public boolean contains(long nodeId) {
            return true;
        }

        public long nodeCount() {
            return this.length;
        }
    }
}

