/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.centrality.CentralityUtils;
import org.neo4j.graphalgo.centrality.DegreeCentralityConfig;
import org.neo4j.graphalgo.centrality.DegreeCentralityConfigImpl;
import org.neo4j.graphalgo.centrality.degreecentrality.DegreeCentrality;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.CentralityScore;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class DegreeCentralityProc
extends AlgoBaseProc<DegreeCentrality, DegreeCentrality, DegreeCentralityConfig> {
    private static final String DESCRIPTION = "Degree centrality measures the number of incoming and outgoing relationships from a node.";

    @Procedure(value="gds.alpha.degree.write", mode=Mode.WRITE)
    @Description(value="Degree centrality measures the number of incoming and outgoing relationships from a node.")
    public Stream<CentralityScore.Stats> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computeResult = this.compute(graphNameOrConfig, configuration);
        return this.write((AlgoBaseProc.ComputationResult<DegreeCentrality, DegreeCentrality, DegreeCentralityConfig>)computeResult);
    }

    @Procedure(name="gds.alpha.degree.stream", mode=Mode.READ)
    @Description(value="Degree centrality measures the number of incoming and outgoing relationships from a node.")
    public Stream<CentralityScore> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computeResult = this.compute(graphNameOrConfig, configuration);
        return CentralityUtils.streamResults(computeResult.graph(), ((DegreeCentrality)computeResult.algorithm()).result());
    }

    private Stream<CentralityScore.Stats> write(AlgoBaseProc.ComputationResult<DegreeCentrality, DegreeCentrality, DegreeCentralityConfig> computeResult) {
        Graph graph = computeResult.graph();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of(new CentralityScore.Stats(0L, 0L, computeResult.createMillis(), 0L, ((DegreeCentralityConfig)computeResult.config()).writeProperty()));
        }
        DegreeCentralityConfig config = (DegreeCentralityConfig)computeResult.config();
        DegreeCentrality algorithm = (DegreeCentrality)computeResult.algorithm();
        AbstractResultBuilder builder = new CentralityScore.Stats.Builder().withNodeCount(graph.nodeCount());
        CentralityUtils.write(this.api, this.log, (IdMapping)computeResult.graph(), algorithm.getTerminationFlag(), algorithm.result(), config, (AbstractResultBuilder<CentralityScore.Stats>)builder);
        builder.withCreateMillis(computeResult.createMillis()).withComputeMillis(computeResult.computeMillis());
        graph.release();
        return Stream.of((CentralityScore.Stats)builder.build());
    }

    protected DegreeCentralityConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper userInput) {
        return new DegreeCentralityConfigImpl(graphName, maybeImplicitCreate, username, userInput);
    }

    protected AlgorithmFactory<DegreeCentrality, DegreeCentralityConfig> algorithmFactory(DegreeCentralityConfig config) {
        return new AlphaAlgorithmFactory<DegreeCentrality, DegreeCentralityConfig>(){

            @Override
            public DegreeCentrality buildAlphaAlgo(Graph graph, DegreeCentralityConfig configuration, AllocationTracker tracker, Log log) {
                return new DegreeCentrality(graph, Pools.DEFAULT, configuration.concurrency(), configuration.isWeighted(), tracker);
            }
        };
    }
}

