/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.similarity;

import com.carrotsearch.hppc.LongDoubleHashMap;
import com.carrotsearch.hppc.LongHashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.neo4j.graphalgo.core.utils.Intersections;
import org.neo4j.graphalgo.impl.similarity.SimilarityVectorAggregator;
import org.neo4j.graphalgo.impl.utils.NumberUtils;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserFunction;

public class SimilaritiesFunc {
    @UserFunction(value="gds.alpha.similarity.jaccard")
    @Description(value="Given two collection vectors, calculate Jaccard similarity")
    public double jaccardSimilarity(@Name(value="vector1") List<Number> vector1, @Name(value="vector2") List<Number> vector2) {
        if (vector1 == null || vector2 == null) {
            return 0.0;
        }
        HashSet<Number> intersectionSet = new HashSet<Number>(vector1);
        intersectionSet.retainAll(vector2);
        int intersection = intersectionSet.size();
        long denominator = vector1.size() + vector2.size() - intersection;
        return denominator == 0L ? 0.0 : (double)intersection / (double)denominator;
    }

    @UserFunction(value="gds.alpha.similarity.cosine")
    @Description(value="Given two collection vectors, calculate cosine similarity")
    public double cosineSimilarity(@Name(value="vector1") List<Number> vector1, @Name(value="vector2") List<Number> vector2) {
        if (vector1.size() != vector2.size() || vector1.size() == 0) {
            throw new RuntimeException("Vectors must be non-empty and of the same size");
        }
        int len = Math.min(vector1.size(), vector2.size());
        double[] weights1 = new double[len];
        double[] weights2 = new double[len];
        for (int i = 0; i < len; ++i) {
            weights1[i] = NumberUtils.getDoubleValue((Number)vector1.get(i));
            weights2[i] = NumberUtils.getDoubleValue((Number)vector2.get(i));
        }
        return Math.sqrt(Intersections.cosineSquare((double[])weights1, (double[])weights2, (int)len));
    }

    @UserAggregationFunction(value="gds.alpha.similarity.asVector")
    @Description(value="Builds a vector of maps containing items and weights")
    public SimilarityVectorAggregator asVector() {
        return new SimilarityVectorAggregator();
    }

    @UserFunction(value="gds.alpha.similarity.pearson")
    @Description(value="Given two collection vectors, calculate pearson similarity")
    public double pearsonSimilarity(@Name(value="vector1") Object rawVector1, @Name(value="vector2") Object rawVector2, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        String listType = config.getOrDefault("vectorType", "numbers").toString();
        if (listType.equalsIgnoreCase("maps")) {
            List vector1 = (List)rawVector1;
            List vector2 = (List)rawVector2;
            LongHashSet ids = new LongHashSet();
            LongDoubleHashMap v1Mappings = new LongDoubleHashMap();
            for (Object entry : vector1) {
                Long id = (Long)entry.get(SimilarityVectorAggregator.CATEGORY_KEY);
                ids.add(id.longValue());
                v1Mappings.put(id.longValue(), ((Double)entry.get(SimilarityVectorAggregator.WEIGHT_KEY)).doubleValue());
            }
            LongDoubleHashMap v2Mappings = new LongDoubleHashMap();
            for (Map entry : vector2) {
                Long id = (Long)entry.get(SimilarityVectorAggregator.CATEGORY_KEY);
                ids.add(id.longValue());
                v2Mappings.put(id.longValue(), ((Double)entry.get(SimilarityVectorAggregator.WEIGHT_KEY)).doubleValue());
            }
            double[] weights1 = new double[ids.size()];
            double[] weights2 = new double[ids.size()];
            double skipValue = Double.NaN;
            int index = 0;
            for (long id : ids.toArray()) {
                weights1[index] = v1Mappings.getOrDefault(id, skipValue);
                weights2[index] = v2Mappings.getOrDefault(id, skipValue);
                ++index;
            }
            return Intersections.pearsonSkip((double[])weights1, (double[])weights2, (int)ids.size(), (double)skipValue);
        }
        List vector1 = (List)rawVector1;
        List vector2 = (List)rawVector2;
        if (vector1.size() != vector2.size() || vector1.size() == 0) {
            throw new RuntimeException("Vectors must be non-empty and of the same size");
        }
        int len = vector1.size();
        double[] weights1 = new double[len];
        double[] weights2 = new double[len];
        for (int i = 0; i < len; ++i) {
            weights1[i] = NumberUtils.getDoubleValue((Number)((Number)vector1.get(i)));
            weights2[i] = NumberUtils.getDoubleValue((Number)((Number)vector2.get(i)));
        }
        return Intersections.pearson((double[])weights1, (double[])weights2, (int)len);
    }

    @UserFunction(value="gds.alpha.similarity.euclideanDistance")
    @Description(value="Given two collection vectors, calculate the euclidean distance (square root of the sum of the squared differences)")
    public double euclideanDistance(@Name(value="vector1") List<Number> vector1, @Name(value="vector2") List<Number> vector2) {
        if (vector1.size() != vector2.size() || vector1.size() == 0) {
            throw new RuntimeException("Vectors must be non-empty and of the same size");
        }
        int len = Math.min(vector1.size(), vector2.size());
        double[] weights1 = new double[len];
        double[] weights2 = new double[len];
        for (int i = 0; i < len; ++i) {
            weights1[i] = NumberUtils.getDoubleValue((Number)vector1.get(i));
            weights2[i] = NumberUtils.getDoubleValue((Number)vector2.get(i));
        }
        return Math.sqrt(Intersections.sumSquareDelta((double[])weights1, (double[])weights2, (int)len));
    }

    @UserFunction(value="gds.alpha.similarity.euclidean")
    @Description(value="Given two collection vectors, calculate similarity based on euclidean distance")
    public double euclideanSimilarity(@Name(value="vector1") List<Number> vector1, @Name(value="vector2") List<Number> vector2) {
        return 1.0 / (1.0 + this.euclideanDistance(vector1, vector2));
    }

    @UserFunction(value="gds.alpha.similarity.overlap")
    @Description(value="Given two collection vectors, calculate overlap similarity")
    public double overlapSimilarity(@Name(value="vector1") List<Number> vector1, @Name(value="vector2") List<Number> vector2) {
        if (vector1 == null || vector2 == null) {
            return 0.0;
        }
        HashSet<Number> intersectionSet = new HashSet<Number>(vector1);
        intersectionSet.retainAll(vector2);
        int intersection = intersectionSet.size();
        long denominator = Math.min(vector1.size(), vector2.size());
        return denominator == 0L ? 0.0 : (double)intersection / (double)denominator;
    }
}

