/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpaths;

import java.util.Optional;
import org.neo4j.graphalgo.annotation.Configuration;
import org.neo4j.graphalgo.annotation.ValueClass;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.RelationshipWeightConfig;
import org.neo4j.graphalgo.config.WritePropertyConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.shortestpaths.ShortestPathsConfigImpl;
import org.neo4j.graphdb.Node;

@ValueClass
@Configuration(value="ShortestPathsConfigImpl")
public interface ShortestPathsConfig
extends AlgoBaseConfig,
RelationshipWeightConfig,
WritePropertyConfig {
    public static final String DEFAULT_TARGET_PROPERTY = "sssp";

    @Configuration.ConvertWith(value="nodeId")
    public long startNode();

    default public String writeProperty() {
        return DEFAULT_TARGET_PROPERTY;
    }

    public static ShortestPathsConfig of(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper userInput) {
        return new ShortestPathsConfigImpl(graphName, maybeImplicitCreate, username, userInput);
    }

    public static long nodeId(Node node) {
        return node.getId();
    }
}

