/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpath;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.core.write.PropertyTranslator;
import org.neo4j.graphalgo.core.write.Translators;
import org.neo4j.graphalgo.impl.ShortestPathDeltaStepping;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.DeltaSteppingProcResult;
import org.neo4j.graphalgo.shortestpath.ShortestPathDeltaSteppingConfig;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ShortestPathDeltaSteppingProc
extends AlgoBaseProc<ShortestPathDeltaStepping, ShortestPathDeltaStepping, ShortestPathDeltaSteppingConfig> {
    private static final String DESCRIPTION = "Delta-Stepping is a non-negative single source shortest paths (NSSSP) algorithm.";

    @Procedure(name="gds.alpha.shortestPath.deltaStepping.stream", mode=Mode.READ)
    @Description(value="Delta-Stepping is a non-negative single source shortest paths (NSSSP) algorithm.")
    public Stream<ShortestPathDeltaStepping.DeltaSteppingResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        if (computationResult.graph().isEmpty()) {
            return Stream.empty();
        }
        return ((ShortestPathDeltaStepping)computationResult.result()).resultStream();
    }

    @Procedure(value="gds.alpha.shortestPath.deltaStepping.write", mode=Mode.WRITE)
    @Description(value="Delta-Stepping is a non-negative single source shortest paths (NSSSP) algorithm.")
    public Stream<DeltaSteppingProcResult> deltaStepping(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        Graph graph = computationResult.graph();
        ShortestPathDeltaStepping algorithm = (ShortestPathDeltaStepping)computationResult.algorithm();
        ShortestPathDeltaSteppingConfig config = (ShortestPathDeltaSteppingConfig)computationResult.config();
        AbstractResultBuilder builder = DeltaSteppingProcResult.builder().withNodeCount(graph.nodeCount());
        if (graph.isEmpty()) {
            return Stream.empty();
        }
        try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((AbstractResultBuilder)builder).withWriteMillis(arg_0));){
            ((NodePropertyExporter)NodePropertyExporter.builder((GraphDatabaseAPI)this.api, (IdMapping)graph, (TerminationFlag)algorithm.getTerminationFlag()).withLog(this.log).parallel(Pools.DEFAULT, config.writeConcurrency()).build()).write(config.writeProperty(), (Object)algorithm.getShortestPaths(), (PropertyTranslator)Translators.DOUBLE_ARRAY_TRANSLATOR);
        }
        return Stream.of((DeltaSteppingProcResult)builder.build());
    }

    protected ShortestPathDeltaSteppingConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ShortestPathDeltaSteppingConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    protected AlgorithmFactory<ShortestPathDeltaStepping, ShortestPathDeltaSteppingConfig> algorithmFactory(ShortestPathDeltaSteppingConfig config) {
        return new AlphaAlgorithmFactory<ShortestPathDeltaStepping, ShortestPathDeltaSteppingConfig>(){

            @Override
            public ShortestPathDeltaStepping buildAlphaAlgo(Graph graph, ShortestPathDeltaSteppingConfig configuration, AllocationTracker tracker, Log log) {
                return new ShortestPathDeltaStepping(graph, configuration.startNode(), configuration.delta());
            }
        };
    }
}

