/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.AtomicDoubleArray;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.core.write.PropertyTranslator;
import org.neo4j.graphalgo.core.write.Translators;
import org.neo4j.graphalgo.impl.betweenness.BetweennessCentrality;
import org.neo4j.graphalgo.impl.betweenness.BetweennessCentralityConfig;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class BetweennessCentralityProc
extends AlgoBaseProc<BetweennessCentrality, BetweennessCentrality, BetweennessCentralityConfig> {
    private static final String DESCRIPTION = "Betweenness centrality is a way of detecting the amount of influence a node has over the flow of information in a graph.";

    @Procedure(name="gds.alpha.betweenness.stream", mode=Mode.READ)
    @Description(value="Betweenness centrality is a way of detecting the amount of influence a node has over the flow of information in a graph.")
    public Stream<BetweennessCentrality.Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        if (computationResult.graph().isEmpty()) {
            return Stream.empty();
        }
        return ((BetweennessCentrality)computationResult.algorithm()).resultStream();
    }

    @Procedure(value="gds.alpha.betweenness.write", mode=Mode.WRITE)
    @Description(value="Betweenness centrality is a way of detecting the amount of influence a node has over the flow of information in a graph.")
    public Stream<BetweennessCentralityProcResult> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        BetweennessCentralityProcResult.Builder builder = BetweennessCentralityProcResult.builder();
        Graph graph = computationResult.graph();
        BetweennessCentrality algo = (BetweennessCentrality)computationResult.algorithm();
        BetweennessCentralityConfig config = (BetweennessCentralityConfig)computationResult.config();
        if (graph.isEmpty()) {
            return Stream.of(builder.build());
        }
        this.computeStats(builder, algo.getCentrality());
        builder.withNodeCount(graph.nodeCount()).withComputeMillis(computationResult.computeMillis()).withCreateMillis(computationResult.createMillis());
        graph.release();
        try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((BetweennessCentralityProcResult.Builder)builder).withWriteMillis(arg_0));){
            AtomicDoubleArray centrality = algo.getCentrality();
            ((NodePropertyExporter)NodePropertyExporter.builder((GraphDatabaseAPI)this.api, (IdMapping)graph, (TerminationFlag)algo.getTerminationFlag()).withLog(this.log).parallel(Pools.DEFAULT, config.writeConcurrency()).build()).write(config.writeProperty(), (Object)centrality, (PropertyTranslator)Translators.ATOMIC_DOUBLE_ARRAY_TRANSLATOR);
        }
        algo.release();
        return Stream.of(builder.build());
    }

    private void computeStats(BetweennessCentralityProcResult.Builder builder, AtomicDoubleArray centrality) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double sum = 0.0;
        for (int i = centrality.length() - 1; i >= 0; --i) {
            double c = centrality.get(i);
            if (c < min) {
                min = c;
            }
            if (c > max) {
                max = c;
            }
            sum += c;
        }
        builder.withCentralityMax(max).withCentralityMin(min).withCentralitySum(sum);
    }

    protected BetweennessCentralityConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return BetweennessCentralityConfig.of(graphName, maybeImplicitCreate, (String)username, (CypherMapWrapper)config);
    }

    protected void validateConfigs(GraphCreateConfig graphCreateConfig, BetweennessCentralityConfig config) {
        config.validate(graphCreateConfig);
    }

    protected AlgorithmFactory<BetweennessCentrality, BetweennessCentralityConfig> algorithmFactory(BetweennessCentralityConfig config) {
        return new AlphaAlgorithmFactory<BetweennessCentrality, BetweennessCentralityConfig>(){

            @Override
            public BetweennessCentrality buildAlphaAlgo(Graph graph, BetweennessCentralityConfig configuration, AllocationTracker tracker, Log log) {
                return (BetweennessCentrality)new BetweennessCentrality(graph, Pools.DEFAULT, configuration.concurrency(), configuration.undirected()).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)BetweennessCentralityProc.this.transaction));
            }
        };
    }

    public static final class BetweennessCentralityProcResult {
        public final long createMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final long nodes;
        public final double minCentrality;
        public final double maxCentrality;
        public final double sumCentrality;

        private BetweennessCentralityProcResult(Long createMillis, Long computeMillis, Long writeMillis, Long nodes, Double centralityMin, Double centralityMax, Double centralitySum) {
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.nodes = nodes;
            this.minCentrality = centralityMin;
            this.maxCentrality = centralityMax;
            this.sumCentrality = centralitySum;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends AbstractResultBuilder<BetweennessCentralityProcResult> {
            private double centralityMin = -1.0;
            private double centralityMax = -1.0;
            private double centralitySum = -1.0;

            public Builder withCentralityMin(double centralityMin) {
                this.centralityMin = centralityMin;
                return this;
            }

            public Builder withCentralityMax(double centralityMax) {
                this.centralityMax = centralityMax;
                return this;
            }

            public Builder withCentralitySum(double centralitySum) {
                this.centralitySum = centralitySum;
                return this;
            }

            public BetweennessCentralityProcResult build() {
                return new BetweennessCentralityProcResult(this.createMillis, this.computeMillis, this.writeMillis, this.nodeCount, this.centralityMin, this.centralityMax, this.centralitySum);
            }
        }
    }
}

