/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.triangle;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.Orientation;
import org.neo4j.graphalgo.RelationshipProjection;
import org.neo4j.graphalgo.RelationshipType;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.impl.triangle.TriangleStream;
import org.neo4j.graphalgo.triangle.TriangleCountBaseConfig;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class TriangleProc
extends AlgoBaseProc<TriangleStream, Stream<TriangleStream.Result>, TriangleCountBaseConfig> {
    static final String DESCRIPTION = "Triangle Stream streams the nodeIds of each triangle in the graph.";

    protected void validateConfigs(GraphCreateConfig graphCreateConfig, TriangleCountBaseConfig config) {
        graphCreateConfig.relationshipProjections().projections().entrySet().stream().filter(entry -> ((RelationshipProjection)entry.getValue()).orientation() != Orientation.UNDIRECTED).forEach(entry -> {
            throw new IllegalArgumentException(String.format("Procedure requires relationship projections to be UNDIRECTED. Projection for `%s` uses orientation `%s`", ((RelationshipType)entry.getKey()).name, ((RelationshipProjection)entry.getValue()).orientation()));
        });
    }

    @Procedure(name="gds.alpha.triangle.stream", mode=Mode.READ)
    @Description(value="Triangle Stream streams the nodeIds of each triangle in the graph.")
    public Stream<TriangleStream.Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration, false, false);
        Graph graph = computationResult.graph();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.empty();
        }
        return (Stream)computationResult.result();
    }

    protected TriangleCountBaseConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return TriangleCountBaseConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<TriangleStream, TriangleCountBaseConfig> algorithmFactory(TriangleCountBaseConfig config) {
        return new AlphaAlgorithmFactory<TriangleStream, TriangleCountBaseConfig>(){

            @Override
            public TriangleStream buildAlphaAlgo(Graph graph, TriangleCountBaseConfig configuration, AllocationTracker tracker, Log log) {
                return (TriangleStream)new TriangleStream(graph, Pools.DEFAULT, configuration.concurrency()).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)TriangleProc.this.transaction));
            }
        };
    }
}

