/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.triangle;

import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.Orientation;
import org.neo4j.graphalgo.RelationshipProjection;
import org.neo4j.graphalgo.RelationshipType;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.triangle.IntersectingTriangleCount;
import org.neo4j.graphalgo.triangle.TriangleCountBaseConfig;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.logging.Log;

public abstract class TriangleBaseProc<CONFIG extends TriangleCountBaseConfig>
extends AlgoBaseProc<IntersectingTriangleCount, IntersectingTriangleCount.TriangleCountResult, CONFIG> {
    static final String DESCRIPTION = "Triangle counting is a community detection graph algorithm that is used to determine the number of triangles passing through each node in the graph.";

    protected void validateConfigs(GraphCreateConfig graphCreateConfig, CONFIG config) {
        graphCreateConfig.relationshipProjections().projections().entrySet().stream().filter(entry -> ((RelationshipProjection)entry.getValue()).orientation() != Orientation.UNDIRECTED).forEach(entry -> {
            throw new IllegalArgumentException(String.format("Procedure requires relationship projections to be UNDIRECTED. Projection for `%s` uses orientation `%s`", ((RelationshipType)entry.getKey()).name, ((RelationshipProjection)entry.getValue()).orientation()));
        });
    }

    protected AlgorithmFactory<IntersectingTriangleCount, CONFIG> algorithmFactory(CONFIG config) {
        return new AlphaAlgorithmFactory<IntersectingTriangleCount, CONFIG>(){

            @Override
            public IntersectingTriangleCount buildAlphaAlgo(Graph graph, CONFIG configuration, AllocationTracker tracker, Log log) {
                return (IntersectingTriangleCount)new IntersectingTriangleCount(graph, Pools.DEFAULT, configuration.concurrency(), AllocationTracker.create()).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)TriangleBaseProc.this.transaction));
            }
        };
    }
}

