/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.triangle;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.WritePropertyConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.utils.paged.HugeDoubleArray;
import org.neo4j.graphalgo.core.utils.paged.PagedAtomicIntegerArray;
import org.neo4j.graphalgo.core.write.ImmutableNodeProperty;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.core.write.PropertyTranslator;
import org.neo4j.graphalgo.impl.triangle.IntersectingTriangleCount;
import org.neo4j.graphalgo.impl.triangle.TriangleCountConfig;
import org.neo4j.graphalgo.result.AbstractCommunityResultBuilder;
import org.neo4j.graphalgo.triangle.TriangleBaseProc;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class TriangleCountProc
extends TriangleBaseProc<IntersectingTriangleCount, PagedAtomicIntegerArray, TriangleCountConfig> {
    @Procedure(name="gds.alpha.triangleCount.stream", mode=Mode.READ)
    @Description(value="Triangle counting is a community detection graph algorithm that is used to determine the number of triangles passing through each node in the graph.")
    public Stream<IntersectingTriangleCount.Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration, false, false);
        Graph graph = computationResult.graph();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.empty();
        }
        return ((IntersectingTriangleCount)computationResult.algorithm()).computeStream();
    }

    @Procedure(value="gds.alpha.triangleCount.write", mode=Mode.WRITE)
    @Description(value="Triangle counting is a community detection graph algorithm that is used to determine the number of triangles passing through each node in the graph.")
    public Stream<Result> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration, false, false);
        AllocationTracker tracker = computationResult.tracker();
        TriangleCountConfig config = (TriangleCountConfig)computationResult.config();
        Graph graph = computationResult.graph();
        IntersectingTriangleCount algorithm = (IntersectingTriangleCount)computationResult.algorithm();
        TriangleCountResultBuilder builder = new TriangleCountResultBuilder(this.callContext, computationResult.tracker()).buildCommunityCount(true).buildHistogram(true);
        builder.withNodeCount(graph.nodeCount()).withConfig((AlgoBaseConfig)config);
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of(builder.buildResult());
        }
        NodePropertyExporter exporter = (NodePropertyExporter)NodePropertyExporter.builder((GraphDatabaseAPI)this.api, (IdMapping)graph, (TerminationFlag)algorithm.getTerminationFlag()).withLog(this.log).parallel(Pools.DEFAULT, config.writeConcurrency()).build();
        PagedAtomicIntegerArray triangles = algorithm.getTriangles();
        String clusteringCoefficientProperty = config.clusteringCoefficientProperty();
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((TriangleCountResultBuilder)builder).withWriteMillis(arg_0));){
            if (clusteringCoefficientProperty != null) {
                exporter.write(Arrays.asList(ImmutableNodeProperty.of((String)config.writeProperty(), (Object)triangles, (PropertyTranslator)PagedAtomicIntegerArray.Translator.INSTANCE), ImmutableNodeProperty.of((String)clusteringCoefficientProperty, (Object)algorithm.getCoefficients(), (PropertyTranslator)HugeDoubleArray.Translator.INSTANCE)));
            } else {
                exporter.write(config.writeProperty(), (Object)triangles, (PropertyTranslator)PagedAtomicIntegerArray.Translator.INSTANCE);
            }
        }
        return Stream.of(builder.withAverageClusteringCoefficient(algorithm.getAverageCoefficient()).withTriangleCount(algorithm.getTriangleCount()).withClusteringCoefficientProperty(clusteringCoefficientProperty).withCommunityFunction(arg_0 -> ((PagedAtomicIntegerArray)triangles).get(arg_0)).withConfig((AlgoBaseConfig)config).withCreateMillis(computationResult.createMillis()).withComputeMillis(computationResult.computeMillis()).withNodePropertiesWritten(exporter.propertiesWritten()).build());
    }

    protected TriangleCountConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return TriangleCountConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<IntersectingTriangleCount, TriangleCountConfig> algorithmFactory(TriangleCountConfig config) {
        return new AlphaAlgorithmFactory<IntersectingTriangleCount, TriangleCountConfig>(){

            @Override
            public IntersectingTriangleCount buildAlphaAlgo(Graph graph, TriangleCountConfig configuration, AllocationTracker tracker, Log log) {
                return (IntersectingTriangleCount)new IntersectingTriangleCount(graph, Pools.DEFAULT, configuration.concurrency(), AllocationTracker.create()).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)TriangleCountProc.this.transaction));
            }
        };
    }

    public class TriangleCountResultBuilder
    extends AbstractCommunityResultBuilder<Result> {
        private double averageClusteringCoefficient;
        private long triangleCount;
        private String clusteringCoefficientProperty;

        public TriangleCountResultBuilder(ProcedureCallContext callContext, AllocationTracker tracker) {
            super(callContext, tracker);
            this.averageClusteringCoefficient = 0.0;
            this.triangleCount = 0L;
        }

        public TriangleCountResultBuilder withAverageClusteringCoefficient(double averageClusteringCoefficient) {
            this.averageClusteringCoefficient = averageClusteringCoefficient;
            return this;
        }

        public TriangleCountResultBuilder withTriangleCount(long triangleCount) {
            this.triangleCount = triangleCount;
            return this;
        }

        public TriangleCountResultBuilder buildHistogram(boolean buildHistogram) {
            this.buildHistogram = buildHistogram;
            return this;
        }

        public TriangleCountResultBuilder buildCommunityCount(boolean buildCommunityCount) {
            this.buildCommunityCount = buildCommunityCount;
            return this;
        }

        public TriangleCountResultBuilder withClusteringCoefficientProperty(String clusteringCoefficientProperty) {
            this.clusteringCoefficientProperty = clusteringCoefficientProperty;
            return this;
        }

        protected Result buildResult() {
            return new Result(this.createMillis, this.computeMillis, this.writeMillis, this.postProcessingDuration, this.nodeCount, this.triangleCount, this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(100.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(99.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(95.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(90.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(75.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(50.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(25.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(10.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(5.0)).orElse(0L), this.maybeCommunityHistogram.map(h -> h.getValueAtPercentile(1.0)).orElse(0L), this.averageClusteringCoefficient, this.config instanceof WritePropertyConfig ? ((WritePropertyConfig)this.config).writeProperty() : "", this.clusteringCoefficientProperty);
        }
    }

    public static class Result {
        public final long createMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final long postProcessingMillis;
        public final long nodeCount;
        public final long triangleCount;
        public final double averageClusteringCoefficient;
        public final long p1;
        public final long p5;
        public final long p10;
        public final long p25;
        public final long p50;
        public final long p75;
        public final long p90;
        public final long p95;
        public final long p99;
        public final long p100;
        public final String writeProperty;
        public final String clusteringCoefficientProperty;

        public Result(long createMillis, long computeMillis, long postProcessingMillis, long writeMillis, long nodeCount, long triangleCount, long p100, long p99, long p95, long p90, long p75, long p50, long p25, long p10, long p5, long p1, double averageClusteringCoefficient, String writeProperty, String clusteringCoefficientProperty) {
            this.createMillis = createMillis;
            this.computeMillis = computeMillis;
            this.postProcessingMillis = postProcessingMillis;
            this.writeMillis = writeMillis;
            this.nodeCount = nodeCount;
            this.averageClusteringCoefficient = averageClusteringCoefficient;
            this.triangleCount = triangleCount;
            this.p100 = p100;
            this.p99 = p99;
            this.p95 = p95;
            this.p90 = p90;
            this.p75 = p75;
            this.p50 = p50;
            this.p25 = p25;
            this.p10 = p10;
            this.p5 = p5;
            this.p1 = p1;
            this.writeProperty = writeProperty;
            this.clusteringCoefficientProperty = clusteringCoefficientProperty;
        }
    }
}

