/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.traverse;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.impl.traverse.Traverse;
import org.neo4j.graphalgo.impl.traverse.TraverseConfig;
import org.neo4j.graphalgo.impl.walking.WalkPath;
import org.neo4j.graphalgo.impl.walking.WalkResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class TraverseProc
extends AlgoBaseProc<Traverse, Traverse, TraverseConfig> {
    private static final String DESCRIPTION = "BFS is a traversal algorithm, which explores all of the neighbor nodes at the present depth prior to moving on to the nodes at the next depth level.";
    private static boolean isBfs;

    @Procedure(name="gds.alpha.bfs.stream", mode=Mode.READ)
    @Description(value="BFS is a traversal algorithm, which explores all of the neighbor nodes at the present depth prior to moving on to the nodes at the next depth level.")
    public Stream<WalkResult> bfs(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        isBfs = true;
        return this.stream(graphNameOrConfig, configuration);
    }

    @Procedure(name="gds.alpha.dfs.stream", mode=Mode.READ)
    @Description(value="BFS is a traversal algorithm, which explores all of the neighbor nodes at the present depth prior to moving on to the nodes at the next depth level.")
    public Stream<WalkResult> dfs(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        isBfs = false;
        return this.stream(graphNameOrConfig, configuration);
    }

    protected TraverseConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper userInput) {
        return TraverseConfig.of(graphName, maybeImplicitCreate, (String)username, (CypherMapWrapper)userInput);
    }

    protected AlgorithmFactory<Traverse, TraverseConfig> algorithmFactory(final TraverseConfig config) {
        return new AlphaAlgorithmFactory<Traverse, TraverseConfig>(){

            @Override
            public Traverse buildAlphaAlgo(Graph graph, TraverseConfig configuration, AllocationTracker tracker, Log log) {
                Traverse.Aggregator aggregatorFunction;
                Traverse.ExitPredicate exitFunction;
                if (!config.targetNodes().isEmpty()) {
                    List mappedTargets = config.targetNodes().stream().map(arg_0 -> ((Graph)graph).toMappedNodeId(arg_0)).collect(Collectors.toList());
                    exitFunction = (s, t, w) -> mappedTargets.contains(t) ? Traverse.ExitPredicate.Result.BREAK : Traverse.ExitPredicate.Result.FOLLOW;
                    aggregatorFunction = (s, t, w) -> 0.0;
                } else if (config.maxDepth() != -1L) {
                    exitFunction = (s, t, w) -> w > (double)config.maxDepth() ? Traverse.ExitPredicate.Result.CONTINUE : Traverse.ExitPredicate.Result.FOLLOW;
                    aggregatorFunction = (s, t, w) -> w + 1.0;
                } else if (config.relationshipWeightProperty() != null && !Double.isNaN(config.maxCost())) {
                    double maxCost = config.maxCost();
                    exitFunction = (s, t, w) -> w > maxCost ? Traverse.ExitPredicate.Result.CONTINUE : Traverse.ExitPredicate.Result.FOLLOW;
                    aggregatorFunction = (s, t, w) -> w + graph.relationshipProperty(s, t, 0.0);
                } else {
                    exitFunction = (s, t, w) -> Traverse.ExitPredicate.Result.FOLLOW;
                    aggregatorFunction = (s, t, w) -> 0.0;
                }
                return isBfs ? Traverse.bfs((Graph)graph, (long)config.startNode(), (Traverse.ExitPredicate)exitFunction, (Traverse.Aggregator)aggregatorFunction) : Traverse.dfs((Graph)graph, (long)config.startNode(), (Traverse.ExitPredicate)exitFunction, (Traverse.Aggregator)aggregatorFunction);
            }
        };
    }

    private Stream<WalkResult> stream(Object graphNameOrConfig, Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        if (computationResult.graph().isEmpty()) {
            return Stream.empty();
        }
        Traverse traverse = (Traverse)computationResult.algorithm();
        long[] nodes = traverse.resultNodes();
        return Stream.of(new WalkResult(nodes, WalkPath.toPath((GraphDatabaseService)this.api, (KernelTransaction)this.transaction, (long[])nodes)));
    }
}

