/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.similarity;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.neo4j.graphalgo.ElementIdentifier;
import org.neo4j.graphalgo.NodeLabel;
import org.neo4j.graphalgo.RelationshipType;
import org.neo4j.graphalgo.api.IdMapGraph;
import org.neo4j.graphalgo.api.NodeProperties;
import org.neo4j.graphalgo.core.huge.HugeGraph;
import org.neo4j.graphalgo.core.loading.DeletionResult;
import org.neo4j.graphalgo.core.loading.GraphStore;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.similarity.NullGraph;
import org.neo4j.values.storable.NumberType;

public class NullGraphStore
extends GraphStore {
    NullGraphStore() {
        super(null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), AllocationTracker.EMPTY);
    }

    public long nodeCount() {
        return 0L;
    }

    public Set<NodeLabel> nodeLabels() {
        return Collections.emptySet();
    }

    public Set<String> nodePropertyKeys(NodeLabel label) {
        return Collections.emptySet();
    }

    public Map<ElementIdentifier, Set<String>> nodePropertyKeys() {
        return Collections.emptyMap();
    }

    public long nodePropertyCount() {
        return 0L;
    }

    public boolean hasNodeProperty(Collection<NodeLabel> labels, String propertyKey) {
        return false;
    }

    public void addNodeProperty(NodeLabel nodeLabel, String propertyKey, NumberType propertyType, NodeProperties propertyValues) {
    }

    public void removeNodeProperty(NodeLabel nodeLabel, String propertyKey) {
    }

    public long relationshipCount() {
        return 0L;
    }

    public long relationshipCount(RelationshipType relationshipType) {
        return 0L;
    }

    public Set<RelationshipType> relationshipTypes() {
        return Collections.emptySet();
    }

    public boolean hasRelationshipType(RelationshipType relationshipType) {
        return false;
    }

    public NumberType relationshipPropertyType(String propertyKey) {
        return NumberType.NO_NUMBER;
    }

    public long relationshipPropertyCount() {
        return 0L;
    }

    public Set<String> relationshipPropertyKeys() {
        return Collections.emptySet();
    }

    public Set<String> relationshipPropertyKeys(RelationshipType relationshipType) {
        return Collections.emptySet();
    }

    public void addRelationshipType(RelationshipType relationshipType, Optional<String> relationshipPropertyKey, Optional<NumberType> relationshipPropertyType, HugeGraph.Relationships relationships) {
    }

    public DeletionResult deleteRelationships(RelationshipType relationshipType) {
        return DeletionResult.of(c -> {});
    }

    protected IdMapGraph createGraph(List<NodeLabel> filteredLabels, List<RelationshipType> relationshipTypes, Optional<String> maybeRelationshipProperty, int concurrency) {
        return new NullGraph();
    }

    public IdMapGraph getUnion() {
        return new NullGraph();
    }

    public void canRelease(boolean canRelease) {
    }

    public void release() {
    }

    static class NullGraphException
    extends UnsupportedOperationException {
        NullGraphException() {
            super("This algorithm does not support operating on named graphs. Please report this stacktrace to https://github.com/neo4j/graph-data-science");
        }
    }
}

