/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.Orientation;
import org.neo4j.graphalgo.RelationshipProjections;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.GraphCreateFromStoreConfig;
import org.neo4j.graphalgo.config.ImmutableGraphCreateFromStoreConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.impl.closeness.ClosenessCentralityConfig;
import org.neo4j.graphalgo.impl.closeness.MSClosenessCentrality;
import org.neo4j.graphalgo.result.AbstractResultBuilder;
import org.neo4j.graphalgo.results.CentralityScore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ClosenessCentralityProc
extends AlgoBaseProc<MSClosenessCentrality, MSClosenessCentrality, ClosenessCentralityConfig> {
    private static final String DESCRIPTION = "Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.";

    @Procedure(name="gds.alpha.closeness.stream", mode=Mode.READ)
    @Description(value="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<MSClosenessCentrality.Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        MSClosenessCentrality algorithm = (MSClosenessCentrality)computationResult.algorithm();
        Graph graph = computationResult.graph();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.empty();
        }
        graph.release();
        return algorithm.resultStream();
    }

    @Procedure(value="gds.alpha.closeness.write", mode=Mode.WRITE)
    @Description(value="Closeness centrality is a way of detecting nodes that are able to spread information very efficiently through a graph.")
    public Stream<CentralityScore.Stats> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        MSClosenessCentrality algorithm = (MSClosenessCentrality)computationResult.algorithm();
        ClosenessCentralityConfig config = (ClosenessCentralityConfig)computationResult.config();
        Graph graph = computationResult.graph();
        AbstractResultBuilder builder = new CentralityScore.Stats.Builder().withNodeCount(graph.nodeCount()).withConfig((AlgoBaseConfig)config).withComputeMillis(computationResult.computeMillis()).withCreateMillis(computationResult.createMillis());
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of(builder.build());
        }
        try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((AbstractResultBuilder)builder).withWriteMillis(arg_0));){
            NodePropertyExporter exporter = (NodePropertyExporter)NodePropertyExporter.builder((GraphDatabaseAPI)this.api, (IdMapping)graph, (TerminationFlag)algorithm.getTerminationFlag()).withLog(this.log).parallel(Pools.DEFAULT, ((ClosenessCentralityConfig)computationResult.config()).writeConcurrency()).build();
            algorithm.export(config.writeProperty(), exporter);
        }
        graph.release();
        return Stream.of(builder.build());
    }

    protected ClosenessCentralityConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        maybeImplicitCreate = maybeImplicitCreate.map(graphCreateConfig -> {
            if (graphCreateConfig instanceof GraphCreateFromStoreConfig) {
                RelationshipProjections.Builder builder = RelationshipProjections.builder();
                graphCreateConfig.relationshipProjections().projections().forEach((id, projection) -> builder.putProjection(id, projection.withOrientation(Orientation.UNDIRECTED)));
                return ImmutableGraphCreateFromStoreConfig.builder().from(graphCreateConfig).relationshipProjections(builder.build()).build();
            }
            return graphCreateConfig;
        });
        return ClosenessCentralityConfig.of(graphName, maybeImplicitCreate, (String)username, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<MSClosenessCentrality, ClosenessCentralityConfig> algorithmFactory(ClosenessCentralityConfig config) {
        return new AlphaAlgorithmFactory<MSClosenessCentrality, ClosenessCentralityConfig>(){

            @Override
            public MSClosenessCentrality buildAlphaAlgo(Graph graph, ClosenessCentralityConfig configuration, AllocationTracker tracker, Log log) {
                return new MSClosenessCentrality(graph, tracker, configuration.concurrency(), Pools.DEFAULT, configuration.improved());
            }
        };
    }
}

