/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.walking;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Degrees;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.ParallelUtil;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.impl.walking.RandomWalk;
import org.neo4j.graphalgo.impl.walking.RandomWalkConfig;
import org.neo4j.graphalgo.impl.walking.WalkPath;
import org.neo4j.graphalgo.impl.walking.WalkResult;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class RandomWalkProc
extends AlgoBaseProc<RandomWalk, Stream<long[]>, RandomWalkConfig> {
    private static final String DESCRIPTION = "Random Walk is an algorithm that provides random paths in a graph. It\u2019s similar to how a drunk person traverses a city.";

    @Procedure(name="gds.alpha.randomWalk.stream", mode=Mode.READ)
    @Description(value="Random Walk is an algorithm that provides random paths in a graph. It\u2019s similar to how a drunk person traverses a city.")
    public Stream<WalkResult> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration, false, false);
        if (computationResult.graph().isEmpty()) {
            computationResult.graph().release();
            return Stream.empty();
        }
        return ((Stream)computationResult.result()).map(nodes -> new WalkResult(nodes, ((RandomWalkConfig)computationResult.config()).path() ? WalkPath.toPath((GraphDatabaseService)this.api, (KernelTransaction)this.transaction, (long[])nodes) : null));
    }

    protected RandomWalkConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return RandomWalkConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<RandomWalk, RandomWalkConfig> algorithmFactory(final RandomWalkConfig config) {
        return new AlphaAlgorithmFactory<RandomWalk, RandomWalkConfig>(){

            @Override
            public RandomWalk buildAlphaAlgo(Graph graph, RandomWalkConfig configuration, AllocationTracker tracker, Log log) {
                Double returnParam = config.returnKey();
                Double inOut = config.inOut();
                RandomWalk.RandomNextNodeStrategy strategy = config.mode().equalsIgnoreCase("random") ? new RandomWalk.RandomNextNodeStrategy(graph, (Degrees)graph) : new RandomWalk.Node2VecStrategy(graph, (Degrees)graph, ((Number)returnParam).doubleValue(), ((Number)inOut).doubleValue());
                int limit = config.walks() == -1L ? Math.toIntExact(graph.nodeCount()) : Math.toIntExact(config.walks());
                PrimitiveIterator.OfInt idStream = (PrimitiveIterator.OfInt)ParallelUtil.parallelStream(IntStream.range(0, limit).unordered(), (int)config.concurrency(), stream -> stream.flatMap(s -> RandomWalkProc.this.idStream(config.start(), graph, limit)).limit(limit).iterator());
                return (RandomWalk)new RandomWalk(graph, (int)config.steps(), (RandomWalk.NextNodeStrategy)strategy, configuration.concurrency(), limit, idStream).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)RandomWalkProc.this.transaction));
            }
        };
    }

    private IntStream idStream(Object start, Graph graph, int limit) {
        int nodeCount = Math.toIntExact(graph.nodeCount());
        if (start instanceof String) {
            LongStream ids;
            String label = start.toString();
            int labelId = this.transaction.tokenRead().nodeLabel(label);
            int countWithLabel = Math.toIntExact(this.transaction.dataRead().countsForNodeWithoutTxState(labelId));
            NodeLabelIndexCursor cursor = this.transaction.cursors().allocateNodeLabelIndexCursor();
            this.transaction.dataRead().nodeLabelScan(labelId, cursor);
            cursor.next();
            if (limit == -1) {
                ids = LongStream.range(0L, countWithLabel).map(i -> cursor.next() ? cursor.nodeReference() : -1L);
            } else {
                int[] indexes = ThreadLocalRandom.current().ints(limit + 1, 0, countWithLabel).sorted().toArray();
                IntStream deltas = IntStream.range(0, limit).map(i -> indexes[i + 1] - indexes[i]);
                ids = deltas.mapToLong(delta -> {
                    while (delta > 0 && cursor.next()) {
                        --delta;
                    }
                    return cursor.nodeReference();
                });
            }
            return (IntStream)ids.map(arg_0 -> ((Graph)graph).toMappedNodeId(arg_0)).mapToInt(Math::toIntExact).onClose(() -> ((NodeLabelIndexCursor)cursor).close());
        }
        if (start instanceof Collection) {
            return ((Collection)start).stream().mapToLong(e -> ((Number)e).longValue()).map(arg_0 -> ((Graph)graph).toMappedNodeId(arg_0)).mapToInt(Math::toIntExact);
        }
        if (start instanceof Number) {
            return LongStream.of(((Number)start).longValue()).map(arg_0 -> ((Graph)graph).toMappedNodeId(arg_0)).mapToInt(Math::toIntExact);
        }
        if (nodeCount < limit) {
            return IntStream.range(0, nodeCount).limit(limit);
        }
        return IntStream.generate(() -> ThreadLocalRandom.current().nextInt(nodeCount)).limit(limit);
    }
}

