/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.triangle;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.impl.triangle.TriangleConfig;
import org.neo4j.graphalgo.impl.triangle.TriangleStream;
import org.neo4j.graphalgo.triangle.TriangleBaseProc;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class TriangleProc
extends TriangleBaseProc<TriangleStream, Stream<TriangleStream.Result>, TriangleConfig> {
    @Procedure(name="gds.alpha.triangle.stream", mode=Mode.READ)
    @Description(value="Triangle counting is a community detection graph algorithm that is used to determine the number of triangles passing through each node in the graph.")
    public Stream<TriangleStream.Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration, false, false);
        Graph graph = computationResult.graph();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.empty();
        }
        return (Stream)computationResult.result();
    }

    protected TriangleConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return TriangleConfig.of((String)username, graphName, maybeImplicitCreate, (CypherMapWrapper)config);
    }

    protected AlgorithmFactory<TriangleStream, TriangleConfig> algorithmFactory(TriangleConfig config) {
        return new AlphaAlgorithmFactory<TriangleStream, TriangleConfig>(){

            @Override
            public TriangleStream buildAlphaAlgo(Graph graph, TriangleConfig configuration, AllocationTracker tracker, Log log) {
                return (TriangleStream)new TriangleStream(graph, Pools.DEFAULT, configuration.concurrency()).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)TriangleProc.this.transaction));
            }
        };
    }
}

