/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpaths;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.impl.shortestpaths.ShortestPathAStar;
import org.neo4j.graphalgo.shortestpaths.ShortestPathAStarConfig;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ShortestPathAStarProc
extends AlgoBaseProc<ShortestPathAStar, ShortestPathAStar, ShortestPathAStarConfig> {
    private static final String DESCRIPTION = "The A* algorithm is a search algorithm and improves on the classic Dijkstra algorithm.";

    @Procedure(name="gds.alpha.shortestPath.astar.stream", mode=Mode.READ)
    @Description(value="The A* algorithm is a search algorithm and improves on the classic Dijkstra algorithm.")
    public Stream<ShortestPathAStar.Result> astarStream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration, false, false);
        Graph graph = computationResult.graph();
        if (graph.isEmpty()) {
            graph.release();
            return Stream.empty();
        }
        ShortestPathAStar algo = (ShortestPathAStar)computationResult.algorithm();
        return algo.resultStream();
    }

    protected ShortestPathAStarConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return ShortestPathAStarConfig.of(graphName, maybeImplicitCreate, username, config);
    }

    protected AlgorithmFactory<ShortestPathAStar, ShortestPathAStarConfig> algorithmFactory(ShortestPathAStarConfig config) {
        return new AlphaAlgorithmFactory<ShortestPathAStar, ShortestPathAStarConfig>(){

            public ShortestPathAStar build(Graph graph, ShortestPathAStarConfig configuration, AllocationTracker tracker, Log log) {
                return new ShortestPathAStar(graph, ShortestPathAStarProc.this.api, ShortestPathAStarProc.this.transaction, configuration.startNodeId(), configuration.endNodeId(), configuration.propertyKeyLat(), configuration.propertyKeyLon());
            }
        };
    }
}

