/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.config.AlgoBaseConfig;
import org.neo4j.graphalgo.config.BaseConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.config.RelationshipWeightConfig;
import org.neo4j.graphalgo.config.WriteConfig;
import org.neo4j.graphalgo.shortestpaths.ShortestPathsConfig;

@Generated(from="ShortestPathsConfig", generator="Immutables")
public final class ImmutableShortestPathsConfig
implements ShortestPathsConfig {
    private final String username;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final String graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final GraphCreateConfig implicitCreateConfig;
    @Nullable
    private final String relationshipWeightProperty;
    private final int writeConcurrency;
    private final long startNode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableShortestPathsConfig(String username, int concurrency, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, @Nullable String relationshipWeightProperty, int writeConcurrency, long startNode) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.concurrency(concurrency);
        this.graphName = graphName.orElse(null);
        this.initShim.relationshipTypes(ImmutableShortestPathsConfig.createUnmodifiableList(false, ImmutableShortestPathsConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableShortestPathsConfig.createUnmodifiableList(false, ImmutableShortestPathsConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig.orElse(null);
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.writeConcurrency(writeConcurrency);
        this.startNode = startNode;
        this.username = this.initShim.username();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableShortestPathsConfig(String username, int concurrency, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, @Nullable String relationshipWeightProperty, int writeConcurrency, long startNode) {
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.concurrency(concurrency);
        this.graphName = graphName;
        this.initShim.relationshipTypes(ImmutableShortestPathsConfig.createUnmodifiableList(false, ImmutableShortestPathsConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableShortestPathsConfig.createUnmodifiableList(false, ImmutableShortestPathsConfig.createSafeList(nodeLabels, true, false)));
        this.implicitCreateConfig = implicitCreateConfig;
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.writeConcurrency(writeConcurrency);
        this.startNode = startNode;
        this.username = this.initShim.username();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableShortestPathsConfig(Builder builder) {
        this.graphName = builder.graphName;
        this.implicitCreateConfig = builder.implicitCreateConfig;
        this.startNode = builder.startNode;
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableShortestPathsConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableShortestPathsConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.relationshipWeightPropertyIsSet()) {
            this.initShim.relationshipWeightProperty(builder.relationshipWeightProperty);
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        this.username = this.initShim.username();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableShortestPathsConfig(String username, Collection<String> configKeys, int concurrency, String graphName, List<String> relationshipTypes, List<String> nodeLabels, GraphCreateConfig implicitCreateConfig, @Nullable String relationshipWeightProperty, int writeConcurrency, long startNode) {
        this.initShim.username(username);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.graphName = graphName;
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.implicitCreateConfig = implicitCreateConfig;
        this.initShim.relationshipWeightProperty(relationshipWeightProperty);
        this.initShim.writeConcurrency(writeConcurrency);
        this.startNode = startNode;
        this.username = this.initShim.username();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.relationshipWeightProperty = this.initShim.relationshipWeightProperty();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private String usernameInitialize() {
        return ShortestPathsConfig.super.username();
    }

    private Collection<String> configKeysInitialize() {
        return ShortestPathsConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return ShortestPathsConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return ShortestPathsConfig.super.concurrency();
    }

    private List<String> relationshipTypesInitialize() {
        return ShortestPathsConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return ShortestPathsConfig.super.nodeLabels();
    }

    @Nullable
    private String relationshipWeightPropertyInitialize() {
        return ShortestPathsConfig.super.relationshipWeightProperty();
    }

    private int writeConcurrencyInitialize() {
        return ShortestPathsConfig.super.writeConcurrency();
    }

    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public Optional<String> graphName() {
        return Optional.ofNullable(this.graphName);
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return Optional.ofNullable(this.implicitCreateConfig);
    }

    @Nullable
    public String relationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipWeightProperty() : this.relationshipWeightProperty;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    @Override
    public long startNode() {
        return this.startNode;
    }

    public final ImmutableShortestPathsConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(newValue, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.writeConcurrency, this.startNode));
    }

    public final ImmutableShortestPathsConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this.username, newValue, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.writeConcurrency, this.startNode));
    }

    public final ImmutableShortestPathsConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this.username, this.configKeys, value, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.writeConcurrency, this.startNode));
    }

    public final ImmutableShortestPathsConfig withGraphName(String value) {
        String newValue = value;
        if (Objects.equals(this.graphName, newValue)) {
            return this;
        }
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this.username, this.configKeys, this.concurrency, newValue, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.writeConcurrency, this.startNode));
    }

    public final ImmutableShortestPathsConfig withGraphName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.graphName, value)) {
            return this;
        }
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this.username, this.configKeys, this.concurrency, value, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.writeConcurrency, this.startNode));
    }

    public final ImmutableShortestPathsConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableShortestPathsConfig.createUnmodifiableList(false, ImmutableShortestPathsConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this.username, this.configKeys, this.concurrency, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.writeConcurrency, this.startNode));
    }

    public final ImmutableShortestPathsConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableShortestPathsConfig.createUnmodifiableList(false, ImmutableShortestPathsConfig.createSafeList(elements, true, false));
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this.username, this.configKeys, this.concurrency, this.graphName, newValue, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.writeConcurrency, this.startNode));
    }

    public final ImmutableShortestPathsConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableShortestPathsConfig.createUnmodifiableList(false, ImmutableShortestPathsConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this.username, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.relationshipWeightProperty, this.writeConcurrency, this.startNode));
    }

    public final ImmutableShortestPathsConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableShortestPathsConfig.createUnmodifiableList(false, ImmutableShortestPathsConfig.createSafeList(elements, true, false));
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this.username, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, newValue, this.implicitCreateConfig, this.relationshipWeightProperty, this.writeConcurrency, this.startNode));
    }

    public final ImmutableShortestPathsConfig withImplicitCreateConfig(GraphCreateConfig value) {
        GraphCreateConfig newValue = value;
        if (this.implicitCreateConfig == newValue) {
            return this;
        }
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this.username, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, newValue, this.relationshipWeightProperty, this.writeConcurrency, this.startNode));
    }

    public final ImmutableShortestPathsConfig withImplicitCreateConfig(Optional<? extends GraphCreateConfig> optional) {
        GraphCreateConfig value = optional.orElse(null);
        if (this.implicitCreateConfig == value) {
            return this;
        }
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this.username, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, value, this.relationshipWeightProperty, this.writeConcurrency, this.startNode));
    }

    public final ImmutableShortestPathsConfig withRelationshipWeightProperty(@Nullable String value) {
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this.username, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, value, this.writeConcurrency, this.startNode));
    }

    public final ImmutableShortestPathsConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this.username, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, value, this.startNode));
    }

    public final ImmutableShortestPathsConfig withStartNode(long value) {
        if (this.startNode == value) {
            return this;
        }
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this.username, this.configKeys, this.concurrency, this.graphName, this.relationshipTypes, this.nodeLabels, this.implicitCreateConfig, this.relationshipWeightProperty, this.writeConcurrency, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableShortestPathsConfig && this.equalTo((ImmutableShortestPathsConfig)another);
    }

    private boolean equalTo(ImmutableShortestPathsConfig another) {
        return this.username.equals(another.username) && this.concurrency == another.concurrency && Objects.equals(this.graphName, another.graphName) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.implicitCreateConfig, another.implicitCreateConfig) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.writeConcurrency == another.writeConcurrency && this.startNode == another.startNode;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.concurrency;
        h += (h << 5) + Objects.hashCode(this.graphName);
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.implicitCreateConfig);
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + Long.hashCode(this.startNode);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ShortestPathsConfig{");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        if (this.graphName != null) {
            builder.append(", ");
            builder.append("graphName=").append(this.graphName);
        }
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.implicitCreateConfig != null) {
            builder.append(", ");
            builder.append("implicitCreateConfig=").append(this.implicitCreateConfig);
        }
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("writeConcurrency=").append(this.writeConcurrency);
        builder.append(", ");
        builder.append("startNode=").append(this.startNode);
        return builder.append("}").toString();
    }

    public static ShortestPathsConfig of(String username, int concurrency, Optional<String> graphName, List<String> relationshipTypes, List<String> nodeLabels, Optional<GraphCreateConfig> implicitCreateConfig, @Nullable String relationshipWeightProperty, int writeConcurrency, long startNode) {
        return ImmutableShortestPathsConfig.of(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, relationshipWeightProperty, writeConcurrency, startNode);
    }

    public static ShortestPathsConfig of(String username, int concurrency, Optional<String> graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<? extends GraphCreateConfig> implicitCreateConfig, @Nullable String relationshipWeightProperty, int writeConcurrency, long startNode) {
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, relationshipWeightProperty, writeConcurrency, startNode));
    }

    public static ShortestPathsConfig of(String username, int concurrency, String graphName, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, GraphCreateConfig implicitCreateConfig, @Nullable String relationshipWeightProperty, int writeConcurrency, long startNode) {
        return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(username, concurrency, graphName, relationshipTypes, nodeLabels, implicitCreateConfig, relationshipWeightProperty, writeConcurrency, startNode));
    }

    private static ImmutableShortestPathsConfig validate(ImmutableShortestPathsConfig instance) {
        instance.validateConcurrency();
        return instance;
    }

    public static ShortestPathsConfig copyOf(ShortestPathsConfig instance) {
        if (instance instanceof ImmutableShortestPathsConfig) {
            return (ImmutableShortestPathsConfig)instance;
        }
        return ImmutableShortestPathsConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ShortestPathsConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_START_NODE = 1L;
        private static final long OPT_BIT_CONCURRENCY = 1L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 2L;
        private static final long OPT_BIT_NODE_LABELS = 4L;
        private static final long OPT_BIT_RELATIONSHIP_WEIGHT_PROPERTY = 8L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 16L;
        private long initBits = 1L;
        private long optBits;
        private String username;
        private Collection<String> configKeys;
        private int concurrency;
        private String graphName;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private GraphCreateConfig implicitCreateConfig;
        private String relationshipWeightProperty;
        private int writeConcurrency;
        private long startNode;

        private Builder() {
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ShortestPathsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String relationshipWeightPropertyValue;
            Object instance;
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.configKeys(instance.configKeys());
                this.username(instance.username());
            }
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyValue = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()) != null) {
                this.relationshipWeightProperty(relationshipWeightPropertyValue);
            }
            if (object instanceof ShortestPathsConfig) {
                instance = (ShortestPathsConfig)object;
                this.startNode(instance.startNode());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                Optional graphNameOptional = instance.graphName();
                if (graphNameOptional.isPresent()) {
                    this.graphName(graphNameOptional);
                }
                this.addAllNodeLabels(instance.nodeLabels());
                this.addAllRelationshipTypes(instance.relationshipTypes());
                Optional implicitCreateConfigOptional = instance.implicitCreateConfig();
                if (implicitCreateConfigOptional.isPresent()) {
                    this.implicitCreateConfig(implicitCreateConfigOptional);
                }
                this.concurrency(instance.concurrency());
            }
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 1L;
            return this;
        }

        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Builder graphName(Optional<String> graphName) {
            this.graphName = graphName.orElse(null);
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 4L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder implicitCreateConfig(GraphCreateConfig implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig;
            return this;
        }

        public final Builder implicitCreateConfig(Optional<? extends GraphCreateConfig> implicitCreateConfig) {
            this.implicitCreateConfig = implicitCreateConfig.orElse(null);
            return this;
        }

        public final Builder relationshipWeightProperty(@Nullable String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.optBits |= 8L;
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder startNode(long startNode) {
            this.startNode = startNode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.username = null;
            this.configKeys = null;
            this.concurrency = 0;
            this.graphName = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.implicitCreateConfig = null;
            this.relationshipWeightProperty = null;
            this.writeConcurrency = 0;
            this.startNode = 0L;
            return this;
        }

        public ShortestPathsConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableShortestPathsConfig.validate(new ImmutableShortestPathsConfig(this));
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean relationshipWeightPropertyIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("startNode");
            }
            return "Cannot build ShortestPathsConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ShortestPathsConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameBuildStage = 0;
        private String username;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte relationshipWeightPropertyBuildStage = 0;
        private String relationshipWeightProperty;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;

        private InitShim() {
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableShortestPathsConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableShortestPathsConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableShortestPathsConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableShortestPathsConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableShortestPathsConfig.createUnmodifiableList(false, ImmutableShortestPathsConfig.createSafeList(ImmutableShortestPathsConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableShortestPathsConfig.createUnmodifiableList(false, ImmutableShortestPathsConfig.createSafeList(ImmutableShortestPathsConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String relationshipWeightProperty() {
            if (this.relationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipWeightPropertyBuildStage == 0) {
                this.relationshipWeightPropertyBuildStage = (byte)-1;
                this.relationshipWeightProperty = ImmutableShortestPathsConfig.this.relationshipWeightPropertyInitialize();
                this.relationshipWeightPropertyBuildStage = 1;
            }
            return this.relationshipWeightProperty;
        }

        void relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            this.relationshipWeightPropertyBuildStage = 1;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableShortestPathsConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.relationshipWeightPropertyBuildStage == -1) {
                attributes.add("relationshipWeightProperty");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            return "Cannot build ShortestPathsConfig, attribute initializers form cycle " + attributes;
        }
    }
}

