/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpaths;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.shortestpaths.AllShortestPathsConfig;

public final class AllShortestPathsConfigImpl
implements AllShortestPathsConfig {
    private final int concurrency;
    private final Optional<String> graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final Optional<GraphCreateConfig> implicitCreateConfig;
    private final String username;
    @Nullable
    private final String relationshipWeightProperty;

    public AllShortestPathsConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        this.concurrency = config.getInt("concurrency", AllShortestPathsConfig.super.concurrency());
        this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)config.getChecked("relationshipTypes", (Object)AllShortestPathsConfig.super.relationshipTypes(), List.class));
        this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)config.getChecked("nodeLabels", (Object)AllShortestPathsConfig.super.nodeLabels(), List.class));
        this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        this.relationshipWeightProperty = StringUtils.trimToNull((String)config.getString("relationshipWeightProperty", AllShortestPathsConfig.super.relationshipWeightProperty()));
        this.validateConcurrency();
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("concurrency", "relationshipTypes", "nodeLabels", "relationshipWeightProperty");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("concurrency", this.concurrency());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        return map;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }
}

