/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpath;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.shortestpath.ShortestPathDeltaSteppingConfig;
import org.neo4j.graphdb.Node;

public final class ShortestPathDeltaSteppingConfigImpl
implements ShortestPathDeltaSteppingConfig {
    private final long startNode;
    private final double delta;
    private final String writeProperty;
    private final String username;
    @Nullable
    private final String relationshipWeightProperty;
    private final int writeConcurrency;
    private final int concurrency;
    private final Optional<String> graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final Optional<GraphCreateConfig> implicitCreateConfig;

    public ShortestPathDeltaSteppingConfigImpl(@NotNull String username, @NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull CypherMapWrapper config) {
        this.startNode = ShortestPathDeltaSteppingConfig.nodeId((Node)config.requireChecked("startNode", Node.class));
        this.delta = config.requireDouble("delta");
        this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)config.getString("writeProperty", ShortestPathDeltaSteppingConfig.super.writeProperty()));
        this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        this.relationshipWeightProperty = StringUtils.trimToNull((String)config.getString("relationshipWeightProperty", ShortestPathDeltaSteppingConfig.super.relationshipWeightProperty()));
        this.writeConcurrency = config.getInt("writeConcurrency", ShortestPathDeltaSteppingConfig.super.writeConcurrency());
        this.concurrency = config.getInt("concurrency", ShortestPathDeltaSteppingConfig.super.concurrency());
        this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)config.getChecked("relationshipTypes", (Object)ShortestPathDeltaSteppingConfig.super.relationshipTypes(), List.class));
        this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)config.getChecked("nodeLabels", (Object)ShortestPathDeltaSteppingConfig.super.nodeLabels(), List.class));
        this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        this.validateConcurrency();
    }

    @Override
    public long startNode() {
        return this.startNode;
    }

    @Override
    public double delta() {
        return this.delta;
    }

    @Override
    public String writeProperty() {
        return this.writeProperty;
    }

    public String username() {
        return this.username;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("startNode", "delta", "writeProperty", "relationshipWeightProperty", "writeConcurrency", "concurrency", "relationshipTypes", "nodeLabels");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("startNode", this.startNode());
        map.put("delta", this.delta());
        map.put("writeProperty", this.writeProperty());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        map.put("writeConcurrency", this.writeConcurrency());
        map.put("concurrency", this.concurrency());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        return map;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }
}

