/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.centrality.BetweennessCentralityProc;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.AtomicDoubleArray;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.core.write.PropertyTranslator;
import org.neo4j.graphalgo.core.write.Translators;
import org.neo4j.graphalgo.impl.betweenness.BetweennessCentrality;
import org.neo4j.graphalgo.impl.betweenness.RABrandesBetweennessCentrality;
import org.neo4j.graphalgo.impl.betweenness.RandomDegreeSelectionStrategy;
import org.neo4j.graphalgo.impl.betweenness.RandomSelectionStrategy;
import org.neo4j.graphalgo.impl.betweenness.SampledBetweennessCentralityConfig;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class SampledBetweennessCentralityProc
extends AlgoBaseProc<RABrandesBetweennessCentrality, RABrandesBetweennessCentrality, SampledBetweennessCentralityConfig> {
    private static final String DESCRIPTION = "Sampled Betweenness centrality computes an approximate score for betweenness centrality.";

    @Procedure(name="gds.alpha.betweenness.sampled.stream", mode=Mode.READ)
    @Description(value="Sampled Betweenness centrality computes an approximate score for betweenness centrality.")
    public Stream<BetweennessCentrality.Result> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        if (computationResult.graph().isEmpty()) {
            return Stream.empty();
        }
        return ((RABrandesBetweennessCentrality)computationResult.algorithm()).resultStream();
    }

    @Procedure(value="gds.alpha.betweenness.sampled.write", mode=Mode.WRITE)
    @Description(value="Sampled Betweenness centrality computes an approximate score for betweenness centrality.")
    public Stream<BetweennessCentralityProc.BetweennessCentralityProcResult> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        BetweennessCentralityProc.BetweennessCentralityProcResult.Builder builder = BetweennessCentralityProc.BetweennessCentralityProcResult.builder();
        Graph graph = computationResult.graph();
        RABrandesBetweennessCentrality algo = (RABrandesBetweennessCentrality)computationResult.algorithm();
        SampledBetweennessCentralityConfig config = (SampledBetweennessCentralityConfig)computationResult.config();
        if (graph.isEmpty()) {
            return Stream.of(builder.build());
        }
        this.computeStats(builder, algo.getCentrality());
        builder.withNodeCount(graph.nodeCount()).withComputeMillis(computationResult.computeMillis()).withCreateMillis(computationResult.createMillis());
        graph.release();
        try (ProgressTimer ignore = ProgressTimer.start(arg_0 -> ((BetweennessCentralityProc.BetweennessCentralityProcResult.Builder)builder).withWriteMillis(arg_0));){
            AtomicDoubleArray centrality = algo.getCentrality();
            ((NodePropertyExporter)NodePropertyExporter.of((GraphDatabaseAPI)this.api, (IdMapping)graph, (TerminationFlag)algo.getTerminationFlag()).withLog(this.log).parallel(Pools.DEFAULT, config.writeConcurrency()).build()).write(config.writeProperty(), (Object)centrality, (PropertyTranslator)Translators.ATOMIC_DOUBLE_ARRAY_TRANSLATOR);
        }
        algo.release();
        return Stream.of(builder.build());
    }

    private void computeStats(BetweennessCentralityProc.BetweennessCentralityProcResult.Builder builder, AtomicDoubleArray centrality) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double sum = 0.0;
        for (int i = centrality.length() - 1; i >= 0; --i) {
            double c = centrality.get(i);
            if (c < min) {
                min = c;
            }
            if (c > max) {
                max = c;
            }
            sum += c;
        }
        builder.withCentralityMax(max).withCentralityMin(min).withCentralitySum(sum);
    }

    protected SampledBetweennessCentralityConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return SampledBetweennessCentralityConfig.of(graphName, maybeImplicitCreate, (String)username, (CypherMapWrapper)config);
    }

    protected void validateConfigs(GraphCreateConfig graphCreateConfig, SampledBetweennessCentralityConfig config) {
        config.validate(graphCreateConfig);
    }

    protected AlgorithmFactory<RABrandesBetweennessCentrality, SampledBetweennessCentralityConfig> algorithmFactory(SampledBetweennessCentralityConfig config) {
        return new AlphaAlgorithmFactory<RABrandesBetweennessCentrality, SampledBetweennessCentralityConfig>(){

            public RABrandesBetweennessCentrality build(Graph graph, SampledBetweennessCentralityConfig configuration, AllocationTracker tracker, Log log) {
                return ((RABrandesBetweennessCentrality)((RABrandesBetweennessCentrality)new RABrandesBetweennessCentrality(graph, Pools.DEFAULT, configuration.concurrency(), SampledBetweennessCentralityProc.this.strategy(configuration, graph), configuration.undirected()).withProgressLogger(ProgressLogger.wrap((Log)log, (String)"BetweennessCentrality"))).withTerminationFlag(TerminationFlag.wrap((KernelTransaction)SampledBetweennessCentralityProc.this.transaction))).withMaxDepth(configuration.maxDepth());
            }
        };
    }

    private RABrandesBetweennessCentrality.SelectionStrategy strategy(SampledBetweennessCentralityConfig configuration, Graph graph) {
        switch (configuration.strategy()) {
            case "degree": {
                return new RandomDegreeSelectionStrategy(graph, Pools.DEFAULT, configuration.concurrency());
            }
            case "random": {
                double probability = configuration.probability();
                if (Double.isNaN(probability)) {
                    probability = Math.log10(graph.nodeCount()) / Math.exp(2.0);
                }
                return new RandomSelectionStrategy(graph, probability);
            }
        }
        throw new IllegalArgumentException("Unknown selection strategy: " + configuration.strategy());
    }
}

