/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.centrality.ArticleRankConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphdb.Node;

public final class ArticleRankConfigImpl
implements ArticleRankConfig {
    private final String writeProperty;
    private final double tolerance;
    private final int maxIterations;
    private final double dampingFactor;
    private final boolean cacheWeights;
    private final int concurrency;
    private final Optional<String> graphName;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final Optional<GraphCreateConfig> implicitCreateConfig;
    private final String username;
    @Nullable
    private final String relationshipWeightProperty;
    private final List<Node> sourceNodes;
    private final int writeConcurrency;

    public ArticleRankConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)config.getString("writeProperty", ArticleRankConfig.super.writeProperty()));
        this.tolerance = config.getDouble("tolerance", ArticleRankConfig.super.tolerance());
        this.maxIterations = config.getInt("maxIterations", ArticleRankConfig.super.maxIterations());
        this.dampingFactor = config.getDouble("dampingFactor", ArticleRankConfig.super.dampingFactor());
        this.cacheWeights = config.getBool("cacheWeights", ArticleRankConfig.super.cacheWeights());
        this.concurrency = config.getInt("concurrency", ArticleRankConfig.super.concurrency());
        this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)config.getChecked("relationshipTypes", (Object)ArticleRankConfig.super.relationshipTypes(), List.class));
        this.nodeLabels = (List)CypherMapWrapper.failOnNull((String)"nodeLabels", (Object)config.getChecked("nodeLabels", (Object)ArticleRankConfig.super.nodeLabels(), List.class));
        this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        this.relationshipWeightProperty = StringUtils.trimToNull((String)config.getString("relationshipWeightProperty", ArticleRankConfig.super.relationshipWeightProperty()));
        this.sourceNodes = (List)CypherMapWrapper.failOnNull((String)"sourceNodes", (Object)config.getChecked("sourceNodes", (Object)ArticleRankConfig.super.sourceNodes(), List.class));
        this.writeConcurrency = config.getInt("writeConcurrency", ArticleRankConfig.super.writeConcurrency());
        this.validateConcurrency();
    }

    @Override
    public String writeProperty() {
        return this.writeProperty;
    }

    public double tolerance() {
        return this.tolerance;
    }

    public int maxIterations() {
        return this.maxIterations;
    }

    public double dampingFactor() {
        return this.dampingFactor;
    }

    public boolean cacheWeights() {
        return this.cacheWeights;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("writeProperty", "tolerance", "maxIterations", "dampingFactor", "cacheWeights", "concurrency", "relationshipTypes", "nodeLabels", "relationshipWeightProperty", "sourceNodes", "writeConcurrency");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("writeProperty", this.writeProperty());
        map.put("tolerance", this.tolerance());
        map.put("maxIterations", this.maxIterations());
        map.put("dampingFactor", this.dampingFactor());
        map.put("cacheWeights", this.cacheWeights());
        map.put("concurrency", this.concurrency());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        map.put("sourceNodes", this.sourceNodes());
        map.put("writeConcurrency", this.writeConcurrency());
        return map;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public List<Node> sourceNodes() {
        return this.sourceNodes;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }
}

