/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.catalog;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.neo4j.graphalgo.BaseProc;
import org.neo4j.graphalgo.config.BaseConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.loading.GraphStore;
import org.neo4j.graphalgo.core.loading.GraphStoreCatalog;
import org.neo4j.graphalgo.core.utils.export.GraphStoreExport;
import org.neo4j.graphalgo.core.utils.export.GraphStoreExportConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class GraphStoreExportProc
extends BaseProc {
    @Procedure(name="gds.alpha.graph.export", mode=Mode.READ)
    @Description(value="Exports a named graph into a new offline Neo4j database.")
    public Stream<GraphStoreExportResult> create(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        CypherMapWrapper cypherConfig = CypherMapWrapper.create(configuration);
        GraphStoreExportConfig config = GraphStoreExportConfig.of((String)this.getUsername(), (CypherMapWrapper)cypherConfig);
        this.validateConfig(cypherConfig, (BaseConfig)config);
        GraphStoreExportResult result = (GraphStoreExportResult)this.runWithExceptionLogging("Graph creation failed", () -> {
            GraphStore graphStore = GraphStoreCatalog.get((String)this.getUsername(), (String)graphName).graphStore();
            GraphStoreExport graphStoreExport = new GraphStoreExport(graphStore, config);
            long start = System.nanoTime();
            graphStoreExport.run();
            long end = System.nanoTime();
            return new GraphStoreExportResult(graphName, config.storeDir(), config.dbName(), graphStore.nodeCount(), graphStore.relationshipCount(), graphStore.relationshipTypes().size(), graphStore.nodePropertyCount(), graphStore.relationshipPropertyCount(), TimeUnit.NANOSECONDS.toMillis(end - start));
        });
        return Stream.of(result);
    }

    public static class GraphStoreExportResult {
        public final String graphName;
        public final String storeDir;
        public final String dbName;
        public final long nodeCount;
        public final long relationshipCount;
        public final long relationshipTypeCount;
        public final long nodePropertyCount;
        public final long relationshipPropertyCount;
        public final long writeMillis;

        public GraphStoreExportResult(String graphName, String storeDir, String dbName, long nodeCount, long relationshipCount, long relationshipTypeCount, long nodePropertyCount, long relationshipPropertyCount, long writeMillis) {
            this.graphName = graphName;
            this.storeDir = storeDir;
            this.dbName = dbName;
            this.nodeCount = nodeCount;
            this.relationshipCount = relationshipCount;
            this.relationshipTypeCount = relationshipTypeCount;
            this.nodePropertyCount = nodePropertyCount;
            this.relationshipPropertyCount = relationshipPropertyCount;
            this.writeMillis = writeMillis;
        }
    }
}

