/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.similarity;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.HdrHistogram.DoubleHistogram;
import org.eclipse.collections.api.tuple.Pair;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.AlphaAlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.impl.similarity.Computations;
import org.neo4j.graphalgo.impl.similarity.SimilarityAlgorithm;
import org.neo4j.graphalgo.impl.similarity.SimilarityAlgorithmResult;
import org.neo4j.graphalgo.impl.similarity.SimilarityConfig;
import org.neo4j.graphalgo.results.SimilarityExporter;
import org.neo4j.graphalgo.results.SimilarityResult;
import org.neo4j.graphalgo.results.SimilaritySummaryResult;
import org.neo4j.graphalgo.similarity.NullGraph;
import org.neo4j.logging.Log;

abstract class SimilarityProc<ALGO extends SimilarityAlgorithm<ALGO, ?>, CONFIG extends SimilarityConfig>
extends AlgoBaseProc<ALGO, SimilarityAlgorithmResult, CONFIG> {
    SimilarityProc() {
    }

    Stream<SimilarityResult> stream(Object graphNameOrConfig, Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult compute = this.compute(graphNameOrConfig, configuration);
        SimilarityAlgorithmResult result = (SimilarityAlgorithmResult)compute.result();
        assert (result != null);
        return result.stream();
    }

    Stream<SimilaritySummaryResult> write(Object graphNameOrConfig, Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult compute = this.compute(graphNameOrConfig, configuration);
        SimilarityConfig config = (SimilarityConfig)compute.config();
        SimilarityAlgorithmResult result = (SimilarityAlgorithmResult)compute.result();
        assert (result != null);
        if (result.isEmpty()) {
            return this.emptyStream(config.writeRelationshipType(), config.writeProperty());
        }
        return this.writeAndAggregateResults(result, config, ((SimilarityAlgorithm)compute.algorithm()).getTerminationFlag());
    }

    abstract ALGO newAlgo(CONFIG var1);

    protected final AlgorithmFactory<ALGO, CONFIG> algorithmFactory(CONFIG config) {
        return new AlphaAlgorithmFactory<ALGO, CONFIG>((SimilarityConfig)config){
            final /* synthetic */ SimilarityConfig val$config;
            {
                this.val$config = similarityConfig;
            }

            public ALGO build(Graph graph, CONFIG configuration, AllocationTracker tracker, Log log) {
                return SimilarityProc.this.newAlgo(this.val$config);
            }
        };
    }

    protected final Graph createGraph(Pair<CONFIG, Optional<String>> configAndName) {
        if (((Optional)configAndName.getTwo()).isPresent()) {
            throw new IllegalArgumentException("Similarity does not run on an explicitly created graph");
        }
        return new NullGraph();
    }

    private Stream<SimilaritySummaryResult> emptyStream(String writeRelationshipType, String writeProperty) {
        return Stream.of(SimilaritySummaryResult.from((long)0L, (long)0L, (long)0L, (AtomicLong)new AtomicLong(0L), (long)-1L, (String)writeRelationshipType, (String)writeProperty, (boolean)false, (DoubleHistogram)new DoubleHistogram(5)));
    }

    private Stream<SimilaritySummaryResult> writeAndAggregateResults(SimilarityAlgorithmResult algoResult, CONFIG config, TerminationFlag terminationFlag) {
        AtomicLong similarityPairs = new AtomicLong();
        DoubleHistogram histogram = new DoubleHistogram(5);
        Consumer<SimilarityResult> recorder = result -> {
            result.record(histogram);
            similarityPairs.getAndIncrement();
        };
        if (config.write()) {
            SimilarityExporter similarityExporter = new SimilarityExporter(this.api, config.writeRelationshipType(), config.writeProperty(), terminationFlag);
            similarityExporter.export(algoResult.stream().peek(recorder), config.writeBatchSize());
        } else {
            algoResult.stream().forEach(recorder);
        }
        return Stream.of(SimilaritySummaryResult.from((long)algoResult.nodes(), (long)algoResult.sourceIdsLength(), (long)algoResult.targetIdsLength(), (AtomicLong)similarityPairs, (long)algoResult.computations().map(Computations::count).orElse(-1L), (String)config.writeRelationshipType(), (String)config.writeProperty(), (boolean)config.write(), (DoubleHistogram)histogram));
    }
}

