/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpaths;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.shortestpaths.ShortestPathAStarConfig;
import org.neo4j.graphdb.Node;

public final class ShortestPathAStarConfigImpl
implements ShortestPathAStarConfig {
    private final String propertyKeyLat;
    private final String propertyKeyLon;
    private final long startNodeId;
    private final long endNodeId;
    private final int concurrency;
    private final Optional<String> graphName;
    private final List<String> relationshipTypes;
    private final Optional<GraphCreateConfig> implicitCreateConfig;
    private final String username;
    @Nullable
    private final String relationshipWeightProperty;

    public ShortestPathAStarConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        this.propertyKeyLat = (String)CypherMapWrapper.failOnNull((String)"propertyKeyLat", (Object)config.getString("propertyKeyLat", ShortestPathAStarConfig.super.propertyKeyLat()));
        this.propertyKeyLon = (String)CypherMapWrapper.failOnNull((String)"propertyKeyLon", (Object)config.getString("propertyKeyLon", ShortestPathAStarConfig.super.propertyKeyLon()));
        this.startNodeId = ShortestPathAStarConfig.nodeId((Node)config.requireChecked("startNode", Node.class));
        this.endNodeId = ShortestPathAStarConfig.nodeId((Node)config.requireChecked("endNode", Node.class));
        this.concurrency = config.getInt("concurrency", ShortestPathAStarConfig.super.concurrency());
        this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)config.getChecked("relationshipTypes", (Object)ShortestPathAStarConfig.super.relationshipTypes(), List.class));
        this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        this.relationshipWeightProperty = config.getString("relationshipWeightProperty", ShortestPathAStarConfig.super.relationshipWeightProperty());
        this.validateConcurrency();
    }

    @Override
    public String propertyKeyLat() {
        return this.propertyKeyLat;
    }

    @Override
    public String propertyKeyLon() {
        return this.propertyKeyLon;
    }

    @Override
    public long startNodeId() {
        return this.startNodeId;
    }

    @Override
    public long endNodeId() {
        return this.endNodeId;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("propertyKeyLat", "propertyKeyLon", "startNode", "endNode", "concurrency", "relationshipTypes", "relationshipWeightProperty");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("propertyKeyLat", this.propertyKeyLat());
        map.put("propertyKeyLon", this.propertyKeyLon());
        map.put("startNode", this.startNodeId());
        map.put("endNode", this.endNodeId());
        map.put("concurrency", this.concurrency());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        return map;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }
}

