/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality.eigenvector;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.centrality.eigenvector.EigenvectorCentralityAlgorithmFactory;
import org.neo4j.graphalgo.centrality.eigenvector.EigenvectorCentralityConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.write.NodePropertyExporter;
import org.neo4j.graphalgo.impl.utils.NormalizationFunction;
import org.neo4j.graphalgo.pagerank.PageRank;
import org.neo4j.graphalgo.results.AbstractResultBuilder;
import org.neo4j.graphalgo.results.CentralityResult;
import org.neo4j.graphalgo.results.CentralityResultWithStatistics;
import org.neo4j.graphalgo.results.CentralityScore;
import org.neo4j.graphalgo.results.PageRankScore;
import org.neo4j.graphalgo.utils.CentralityUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class EigenvectorCentralityProc
extends AlgoBaseProc<PageRank, PageRank, EigenvectorCentralityConfig> {
    private static final String DESCRIPTION = "Eigenvector Centrality measures the transitive influence or connectivity of nodes.";

    @Procedure(value="gds.alpha.eigenvector.write", mode=Mode.WRITE)
    @Description(value="Eigenvector Centrality measures the transitive influence or connectivity of nodes.")
    public Stream<PageRankScore.Stats> write(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        PageRank algorithm = (PageRank)computationResult.algorithm();
        Graph graph = computationResult.graph();
        CentralityResultWithStatistics stats = CentralityResultWithStatistics.of((CentralityResult)algorithm.result(), (int)((EigenvectorCentralityConfig)computationResult.config()).concurrency());
        EigenvectorCentralityConfig config = (EigenvectorCentralityConfig)computationResult.config();
        CentralityResult normalizedResults = this.normalization(config.normalization()).apply(stats);
        AbstractResultBuilder statsBuilder = new PageRankScore.Stats.Builder().withIterations((long)algorithm.iterations()).withDampingFactor(algorithm.dampingFactor()).withWriteProperty(config.writeProperty()).withCreateMillis(computationResult.createMillis()).withComputeMillis(computationResult.computeMillis());
        if (graph.isEmpty()) {
            graph.release();
            return Stream.of(statsBuilder.build());
        }
        try (ProgressTimer ignored = statsBuilder.timeWrite();){
            NodePropertyExporter exporter = (NodePropertyExporter)NodePropertyExporter.of((GraphDatabaseAPI)this.api, (IdMapping)computationResult.graph(), (TerminationFlag)algorithm.getTerminationFlag()).withLog(this.log).parallel(Pools.DEFAULT, config.writeConcurrency()).build();
            normalizedResults.export(config.writeProperty(), exporter);
        }
        graph.release();
        return Stream.of(statsBuilder.build());
    }

    @Procedure(name="gds.alpha.eigenvector.stream", mode=Mode.READ)
    @Description(value="Eigenvector Centrality measures the transitive influence or connectivity of nodes.")
    public Stream<CentralityScore> stream(@Name(value="graphName") Object graphNameOrConfig, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        AlgoBaseProc.ComputationResult computationResult = this.compute(graphNameOrConfig, configuration);
        CentralityResultWithStatistics centralityResult = CentralityResultWithStatistics.of((CentralityResult)((PageRank)computationResult.result()).result(), (int)((EigenvectorCentralityConfig)computationResult.config()).concurrency());
        String normalization = ((EigenvectorCentralityConfig)computationResult.config()).normalization();
        return CentralityUtils.streamResults(computationResult.graph(), this.normalization(normalization).apply(centralityResult));
    }

    protected AlgorithmFactory<PageRank, EigenvectorCentralityConfig> algorithmFactory(EigenvectorCentralityConfig config) {
        return new EigenvectorCentralityAlgorithmFactory();
    }

    protected EigenvectorCentralityConfig newConfig(String username, Optional<String> graphName, Optional<GraphCreateConfig> maybeImplicitCreate, CypherMapWrapper config) {
        return EigenvectorCentralityConfig.of(username, graphName, maybeImplicitCreate, config);
    }

    private NormalizationFunction normalization(String normalization) {
        return NormalizationFunction.valueOf((String)normalization.toUpperCase());
    }
}

