/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality.eigenvector;

import org.neo4j.graphalgo.AlgorithmFactory;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.centrality.eigenvector.EigenvectorCentralityConfig;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.utils.mem.MemoryEstimation;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.pagerank.LabsPageRankAlgorithmType;
import org.neo4j.graphalgo.pagerank.PageRank;
import org.neo4j.logging.Log;

class EigenvectorCentralityAlgorithmFactory
extends AlgorithmFactory<PageRank, EigenvectorCentralityConfig> {
    EigenvectorCentralityAlgorithmFactory() {
    }

    public PageRank build(Graph graph, EigenvectorCentralityConfig configuration, AllocationTracker tracker, Log log) {
        PageRank.Config algoConfig = new PageRank.Config(configuration.maxIterations(), 1.0, PageRank.DEFAULT_TOLERANCE.doubleValue());
        return LabsPageRankAlgorithmType.EIGENVECTOR_CENTRALITY.create(graph, configuration.sourceNodeIds(), algoConfig, configuration.concurrency(), Pools.DEFAULT, tracker);
    }

    public MemoryEstimation memoryEstimation(EigenvectorCentralityConfig configuration) {
        throw new UnsupportedOperationException("Estimation is not implemented for this algorithm.");
    }
}

