/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.triangle;

import org.neo4j.graphalgo.AlgoBaseProc;
import org.neo4j.graphalgo.Algorithm;
import org.neo4j.graphalgo.ElementIdentifier;
import org.neo4j.graphalgo.Orientation;
import org.neo4j.graphalgo.RelationshipProjection;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.impl.triangle.TriangleConfig;

public abstract class TriangleBaseProc<A extends Algorithm<A, RESULT>, RESULT, CONFIG extends TriangleConfig>
extends AlgoBaseProc<A, RESULT, CONFIG> {
    static final String DESCRIPTION = "Triangle counting is a community detection graph algorithm that is used to determine the number of triangles passing through each node in the graph.";

    protected void validateGraphCreateConfig(GraphCreateConfig graphCreateConfig, CONFIG config) {
        graphCreateConfig.relationshipProjections().projections().entrySet().stream().filter(entry -> ((RelationshipProjection)entry.getValue()).orientation() != Orientation.UNDIRECTED).forEach(entry -> {
            throw new IllegalArgumentException(String.format("Procedure requires relationship projections to be UNDIRECTED. Projection for `%s` uses orientation `%s`", ((ElementIdentifier)entry.getKey()).name, ((RelationshipProjection)entry.getValue()).orientation()));
        });
    }
}

