/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.spanningtree;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.spanningtree.KSpanningTreeConfig;

public final class KSpanningTreeConfigImpl
implements KSpanningTreeConfig {
    private final long k;
    private final String writeProperty;
    private final long startNodeId;
    private final int concurrency;
    private final Optional<String> graphName;
    private final List<String> relationshipTypes;
    private final Optional<GraphCreateConfig> implicitCreateConfig;
    private final String username;
    private final int writeConcurrency;
    @Nullable
    private final String relationshipWeightProperty;

    public KSpanningTreeConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        this.k = config.requireLong("k");
        this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)config.getString("writeProperty", KSpanningTreeConfig.super.writeProperty()));
        this.startNodeId = config.requireLong("startNodeId");
        this.concurrency = config.getInt("concurrency", KSpanningTreeConfig.super.concurrency());
        this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)config.getChecked("relationshipTypes", (Object)KSpanningTreeConfig.super.relationshipTypes(), List.class));
        this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        this.writeConcurrency = config.getInt("writeConcurrency", KSpanningTreeConfig.super.writeConcurrency());
        this.relationshipWeightProperty = config.getString("relationshipWeightProperty", KSpanningTreeConfig.super.relationshipWeightProperty());
        this.validateConcurrency();
    }

    @Override
    public long k() {
        return this.k;
    }

    @Override
    public String writeProperty() {
        return this.writeProperty;
    }

    @Override
    public long startNodeId() {
        return this.startNodeId;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("k", "writeProperty", "startNodeId", "concurrency", "relationshipTypes", "writeConcurrency", "relationshipWeightProperty");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("k", this.k());
        map.put("writeProperty", this.writeProperty());
        map.put("startNodeId", this.startNodeId());
        map.put("concurrency", this.concurrency());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("writeConcurrency", this.writeConcurrency());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        return map;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }
}

