/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.shortestpaths;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphalgo.shortestpaths.ShortestPathsConfig;
import org.neo4j.graphdb.Node;

public final class ShortestPathsConfigImpl
implements ShortestPathsConfig {
    private final long startNode;
    private final String writeProperty;
    private final int concurrency;
    private final Optional<String> graphName;
    private final List<String> relationshipTypes;
    private final Optional<GraphCreateConfig> implicitCreateConfig;
    private final String username;
    @Nullable
    private final String relationshipWeightProperty;
    private final int writeConcurrency;

    public ShortestPathsConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        this.startNode = ShortestPathsConfig.nodeId((Node)config.requireChecked("startNode", Node.class));
        this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)config.getString("writeProperty", ShortestPathsConfig.super.writeProperty()));
        this.concurrency = config.getInt("concurrency", ShortestPathsConfig.super.concurrency());
        this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)config.getChecked("relationshipTypes", (Object)ShortestPathsConfig.super.relationshipTypes(), List.class));
        this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        this.relationshipWeightProperty = config.getString("relationshipWeightProperty", ShortestPathsConfig.super.relationshipWeightProperty());
        this.writeConcurrency = config.getInt("writeConcurrency", ShortestPathsConfig.super.writeConcurrency());
        this.validateConcurrency();
    }

    @Override
    public long startNode() {
        return this.startNode;
    }

    @Override
    public String writeProperty() {
        return this.writeProperty;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("startNode", "writeProperty", "concurrency", "relationshipTypes", "relationshipWeightProperty", "writeConcurrency");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("startNode", this.startNode());
        map.put("writeProperty", this.writeProperty());
        map.put("concurrency", this.concurrency());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        map.put("writeConcurrency", this.writeConcurrency());
        return map;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }
}

