/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.centrality.eigenvector;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.centrality.eigenvector.EigenvectorCentralityConfig;
import org.neo4j.graphalgo.config.GraphCreateConfig;
import org.neo4j.graphalgo.core.CypherMapWrapper;
import org.neo4j.graphdb.Node;

public final class EigenvectorCentralityConfigImpl
implements EigenvectorCentralityConfig {
    private final int maxIterations;
    private final String writeProperty;
    private final String normalization;
    private final int concurrency;
    private final Optional<String> graphName;
    private final List<String> relationshipTypes;
    private final Optional<GraphCreateConfig> implicitCreateConfig;
    private final String username;
    private final List<Node> sourceNodes;
    private final int writeConcurrency;
    @Nullable
    private final String relationshipWeightProperty;

    public EigenvectorCentralityConfigImpl(@NotNull Optional<String> graphName, @NotNull Optional<GraphCreateConfig> implicitCreateConfig, @NotNull String username, @NotNull CypherMapWrapper config) {
        this.maxIterations = config.getInt("maxIterations", EigenvectorCentralityConfig.super.maxIterations());
        this.writeProperty = (String)CypherMapWrapper.failOnNull((String)"writeProperty", (Object)config.getString("writeProperty", EigenvectorCentralityConfig.super.writeProperty()));
        this.normalization = (String)CypherMapWrapper.failOnNull((String)"normalization", (Object)config.getString("normalization", EigenvectorCentralityConfig.super.normalization()));
        this.concurrency = config.getInt("concurrency", EigenvectorCentralityConfig.super.concurrency());
        this.graphName = (Optional)CypherMapWrapper.failOnNull((String)"graphName", graphName);
        this.relationshipTypes = (List)CypherMapWrapper.failOnNull((String)"relationshipTypes", (Object)config.getChecked("relationshipTypes", (Object)EigenvectorCentralityConfig.super.relationshipTypes(), List.class));
        this.implicitCreateConfig = (Optional)CypherMapWrapper.failOnNull((String)"implicitCreateConfig", implicitCreateConfig);
        this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        this.sourceNodes = (List)CypherMapWrapper.failOnNull((String)"sourceNodes", (Object)config.getChecked("sourceNodes", (Object)EigenvectorCentralityConfig.super.sourceNodes(), List.class));
        this.writeConcurrency = config.getInt("writeConcurrency", EigenvectorCentralityConfig.super.writeConcurrency());
        this.relationshipWeightProperty = config.getString("relationshipWeightProperty", EigenvectorCentralityConfig.super.relationshipWeightProperty());
        this.validateConcurrency();
    }

    @Override
    public int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public String writeProperty() {
        return this.writeProperty;
    }

    @Override
    public String normalization() {
        return this.normalization;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public Optional<String> graphName() {
        return this.graphName;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public Optional<GraphCreateConfig> implicitCreateConfig() {
        return this.implicitCreateConfig;
    }

    public String username() {
        return this.username;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("maxIterations", "writeProperty", "normalization", "concurrency", "relationshipTypes", "sourceNodes", "writeConcurrency", "relationshipWeightProperty");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("maxIterations", this.maxIterations());
        map.put("writeProperty", this.writeProperty());
        map.put("normalization", this.normalization());
        map.put("concurrency", this.concurrency());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("sourceNodes", this.sourceNodes());
        map.put("writeConcurrency", this.writeConcurrency());
        map.put("relationshipWeightProperty", this.relationshipWeightProperty());
        return map;
    }

    public List<Node> sourceNodes() {
        return this.sourceNodes;
    }

    public int writeConcurrency() {
        return this.writeConcurrency;
    }

    @Nullable
    public String relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }
}

